% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insertPackage.R
\name{insertPackage}
\alias{insertPackage}
\alias{drat:::insert}
\alias{insert}
\title{Insert a package source or binary file into a drat repository}
\usage{
insertPackage(file, repodir = getOption("dratRepo", "~/git/drat"),
  commit = FALSE, pullfirst = FALSE, action = c("none", "archive",
  "prune"), ...)

insert(...)
}
\arguments{
\item{file}{An R package in source or binary format,}

\item{repodir}{A local directory corresponding to the repository
top-level directory.}

\item{commit}{Either boolean toggle to select automatic git operations
\sQuote{add}, \sQuote{commit}, and \sQuote{push} or, alternatively,
a character variable can be used to specify a commit message; this also
implies the \sQuote{TRUE} values in other contexts.}

\item{pullfirst}{Boolean toggle to call \code{git pull} before inserting the package.}

\item{action}{A character string containing one of: \dQuote{none}
(the default; add the new package into the repo, effectively masking
previous versions), \dQuote{archive} (place any previous versions into
a package-specific archive folder, creating such an archive if it does
not already exist), or \dQuote{prune} (calling \code{\link{pruneRepo}}).}

\item{...}{For \code{insert} the aliases variant, a catch-all collection of
parameters. For \code{insertPackage} arguments passed to \code{write_PACKAGES}.}
}
\value{
NULL is returned.
}
\description{
R can use multiple archives: CRAN, BioConductor and Omegahat have
been supported for years.  It is equally easy to add local
archives from the same machine, or local network, or university /
company network as well as other publically available
repositories.  This function aids in the process, and defaults to
inserting a given source archive into a given repository.
}
\details{
This function inserts the given (source or binary) package file
into the given (local) package repository and updates the
index. By setting the \code{commit} option to \code{TRUE}, one can
then push to a remote git code repository. If the
\code{\link[git2r]{git2r}} package is installed, it is used for
the interaction with the git repository; otherwise the \code{git}
shell command is used.

An aliased function \code{insert} is also available, but not
exported via \code{NAMESPACE} to not clobber a possibly unrelated
function; use it via \code{drat:::insert()}.
}
\section{Options}{


Set using \code{\link{options}}

\describe{
  \item{\code{dratRepo}}{Path to git repo. Defaults to \code{~/git/drat}}
  \item{\code{dratBranch}}{The git branch to store packages on. Defaults to \code{gh-pages}}
}
}

\examples{
\dontrun{
  insertPackage("foo_0.2.3.tar.gz")   # inserts into (default) repo
  insertPackage("foo_0.2.3.tar.gz", "/nas/R/")  # ... into local dir
}
\dontrun{
  insertPackage("foo_0.2.3.tar.gz", action = "prune")   # prunes any older copies
  insertPackage("foo_0.2.3.tar.gz", action = "archive")   # archives any older copies
}
}
\author{
Dirk Eddelbuettel
}
