% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop.R
\name{generate_set_hook}
\alias{generate_set_hook}
\alias{generate_stop_hook}
\alias{generate_warn_hook}
\alias{set_hook}
\alias{generate_get_hook}
\alias{stop_hook}
\alias{warn_hook}
\title{Error displaying a call located at a hook location}
\usage{
generate_set_hook(namespace)

generate_stop_hook(namespace)

generate_warn_hook(namespace)

set_hook()

generate_get_hook(namespace)

stop_hook(..., msg = NULL, envir = parent.frame(), verbatim = FALSE)

warn_hook(..., envir = parent.frame(), immediate. = FALSE, verbatim = FALSE)
}
\arguments{
\item{namespace}{Character scalar giving the namespace for which the hooks are valid. Only useful
when hook functions are used in a package.}

\item{...}{Objects that will be coerced to character and will compose the error message.}

\item{msg}{A character vector, default is \code{NULL}. If provided, this message will be displayed right under the error message. This is mostly useful when the text contains formatting because the function \code{\link{stop}} used to send the error message erases any formatting.}

\item{envir}{An environment, default is \code{parent.frame()}. Only relevant if the error/warning message contains
interpolation (interpolation is performed with \href{https://github.com/lrberge/stringmagic}{stringmagic}). It tells
where the variables to be interpolated should be found. In general you should not worry about this argument.}

\item{verbatim}{Logical scalar, default is \code{FALSE}. By default the error/warning message allows variable
interpolation with \href{https://github.com/lrberge/stringmagic}{stringmagic}. To disable interpolation,
use \code{verbatim = TRUE}.}

\item{immediate.}{Whether the warning message should be prompted directly. Defaults to \code{FALSE}.}
}
\description{
When devising complex functions, errors or warnings can be deeply nested in internal
function calls while the user-relevant call is way up the stack. In such cases, these "hook"
functions facilitate the creation of error/warnings informative for the user.
}
\details{
These functions are useful when developing complex functions relying on nested internal functions.
It is important for the user to know where the errors/warnings come from for quick debugging.
This "_hook" family of functions write the call of the user-level function even if the errors
happen at the level of the internal functions.

If you need these functions within a package, you need to generate the \code{set_hook}, \code{stop_hook} and
\code{warn_hook} functions so that they set, and look up for, hooks speficic to your function. This ensures that
if other functions outside your package also use hooks, there will be no conflict. The only thing to do
is to write this somewhere in the package files:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{set_hook = generate_set_hook("pkg_name")
stop_hook = generate_stop_hook("pkg_name")
warn_hook = generate_warn_hook("pkg_name")
}\if{html}{\out{</div>}}
}
\section{Functions}{
\itemize{
\item \code{generate_set_hook()}: Generates a package specific \code{set_hook} function

\item \code{generate_stop_hook()}: Generates a package specific \code{stop_hook} function

\item \code{generate_warn_hook()}: Generates a package specific \code{warn_hook} function

\item \code{set_hook()}: Marks the function as the hook

\item \code{generate_get_hook()}: Generates the function giving the number of frames we
need to go up the call stack to find the hooked function

\item \code{warn_hook()}: Warning with a call located at a hook location

}}
\examples{

# The example needs to be complex since it's about nested functions, sorry
# Let's say you have an internal function that is dispatched into several 
# user-level functions

my_mean = function(x, drop_na = FALSE){
  set_hook()
  my_mean_internal(x = x, drop_na = drop_na)
}

my_mean_skip_na = function(x){
  set_hook()
  my_mean_internal(x = x, drop_na = TRUE)
}

my_mean_internal = function(x, drop_na){
  # simple check
  if(!is.numeric(x)){
    # note that we use string interpolation with stringmagic.
    stop_hook("The argument `x` must be numeric. PROBLEM: it is of class {enum.bq ? class(x)}.")
  }

  if(drop_na){
    return(mean(x, na.rm = TRUE))
  } else {
    return(mean(x, na.rm = FALSE))
  }
}

# Let's run the function with a wrong argument
x = "five"
try(my_mean(x))

# => the error message reports that the error comes from my_mean 
#    and *not* my_mean_internal
 

}
\seealso{
Regular stop functions with interpolation: \code{\link[=stop_up]{stop_up()}}. Regular argument checking
with \code{\link[=check_arg]{check_arg()}} and \code{\link[=check_set_arg]{check_set_arg()}}.
}
\author{
Laurent Berge
}
