% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmm.R
\name{getStationaryLaw.dmm}
\alias{getStationaryLaw.dmm}
\title{Get the stationary laws of the DMM}
\usage{
\method{getStationaryLaw}{dmm}(x, pos, all.pos = FALSE, internal = FALSE, ncpu = 2)
}
\arguments{
\item{x}{An object of class \code{dmm}}

\item{pos}{A positive integer giving the position along the sequence on which the stationary law of the DMM should be computed}

\item{all.pos}{`FALSE` (default, evaluation at position index) ; `TRUE` (evaluation for all position indices)}

\item{internal}{`FALSE` (default) ; `TRUE` (for internal use of th initial law of \link[drimmR]{fitdmm} and word applications)}

\item{ncpu}{Default=2. Represents the number of cores used to parallelized computation. If ncpu=-1, then it uses all available cores.}
}
\value{
A vector or matrix of stationary law probabilities
}
\description{
Evaluate the stationary law of the DMM at a given position or at every position
}
\details{
Stationary law at position t is evaluated by solving \eqn{\mu_t \ \pi_{\frac{t}{n}} = \mu}
}
\examples{
data(lambda, package = "drimmR")
dmm <- fitdmm(lambda, 1, 1, c('a','c','g','t'), init.estim = "freq", fit.method="sum")
t <- 10
getStationaryLaw(dmm,pos=t)
}
\references{
\insertRef{BaVe2018}{drimmR}
\insertRef{Ver08}{drimmR}
}
\seealso{
\link[drimmR]{fitdmm}, \link[drimmR]{getTransitionMatrix}, \link[drimmR]{stationary_distributions}, \link[drimmR]{getDistribution}
}
\author{
Alexandre Seiller
}
