% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate.R
\name{estimateQrn_loop}
\alias{estimateQrn_loop}
\title{estimateQrn_loop}
\usage{
estimateQrn_loop(
  validRows,
  Y,
  A,
  W,
  DeltaA,
  DeltaY,
  Qn,
  gn,
  SL_Qr,
  glm_Qr,
  family,
  a_0,
  returnModels,
  use_future
)
}
\arguments{
\item{validRows}{A \code{list} of length \code{cvFolds} containing the row
indexes of observations to include in validation fold.}

\item{Y}{A vector of continuous or binary outcomes.}

\item{A}{A vector of binary treatment assignment (assumed to be equal to 0 or
1)}

\item{W}{A \code{data.frame} of named covariates}

\item{DeltaA}{Indicator of missing treatment (assumed to be equal to 0 if
missing 1 if observed)}

\item{DeltaY}{Indicator of missing outcome (assumed to be equal to 0 if
missing 1 if observed)}

\item{Qn}{A list of outcome regression estimates evaluated on observed data.
If NULL then 0 is used for all Qn (as is needed to estimate reduced
dimension regression for adaptive_iptw)}

\item{gn}{A list of propensity regression estimates evaluated on observed
data}

\item{SL_Qr}{A vector of characters or a list describing the Super Learner
library to be used for the first reduced-dimension regression.}

\item{glm_Qr}{A character describing a formula to be used in the call to
\code{glm} for the first reduced-dimension regression. Ignored if
\code{SL_gr!=NULL}.}

\item{family}{Should be gaussian() unless called from adaptive_iptw with
binary \code{Y}.}

\item{a_0}{A list of fixed treatment values.}

\item{returnModels}{A boolean indicating whether to return model fits for the
outcome regression, propensity score, and reduced-dimension regressions.}

\item{use_future}{Should \code{future} be used in the fitting process.}
}
\description{
Helper function to clean up internal code of \code{drtmle} function.
}
