% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{f_dose_ongoing_cpp}
\alias{f_dose_ongoing_cpp}
\title{Dosing Date Imputation for Ongoing Patients}
\usage{
f_dose_ongoing_cpp(usubjid, V, C, D, model_ki, theta_ki, muT, sigmaT)
}
\arguments{
\item{usubjid}{The unique subject ID.}

\item{V}{The last dosing visit date relative to randomization.}

\item{C}{The cutoff date relative to randomization.}

\item{D}{The discontinuation date relative to randomization.}

\item{model_ki}{The model for the number of skipped visits between
two consecutive drug dispensing visits.}

\item{theta_ki}{The model parameters for the number of skipped visits
between two consecutive drug dispensing visits.}

\item{muT}{The regression coefficient for the linear model for the
gap time between two consecutive drug dispensing visits.}

\item{sigmaT}{The residual standard deviation for the linear model
for the gap time between two consecutive drug dispensing visits.}
}
\value{
A data frame with two variables:

* \code{usubjid}: The unique subject ID.

* \code{day}: The dosing visit date relative to randomization.
}
\description{
Imputes the dosing dates after cutoff for ongoing
patients with dosing records.
}
\examples{
set.seed(314)

f_dose_ongoing_cpp(
  usubjid = "A001", V = 297, C = 329, D = 569,
  model_ki = "zip", theta_ki = c(0.4, 2.5),
  muT = 21, sigmaT = 2.3)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
