% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{text_to_sentences}
\alias{text_to_sentences}
\title{text_to_sentences splits a string of text \code{x} 
(consisting of one or more character strings) 
into a vector of its constituting sentences.}
\usage{
text_to_sentences(x, split_delim = "\\\\.|\\\\?|!", force_delim = FALSE)
}
\arguments{
\item{x}{A string of text (required), 
typically a character vector.}

\item{split_delim}{Sentence delimiters (as regex) 
used to split \code{x} into substrings. 
By default, \code{split_delim = "\\.|\\?|!"}.}

\item{force_delim}{Boolean: Enforce splitting at 
\code{split_delim}? 
If \code{force_delim = FALSE} (as per default), 
the function assumes a standard sentence-splitting pattern: 
\code{split_delim} is followed by a single space and a capital letter. 
If \code{force_delim = TRUE}, splits at \code{split_delim} are 
enforced (regardless of spacing or capitalization).}
}
\description{
\code{text_to_sentences} splits at given punctuation marks 
(as a regular expression, default: \code{split_delim = "\\.|\\?|!"})  
and removes empty leading and trailing spaces before returning 
a vector of the remaining character sequences (as the sentences).
}
\details{
The Boolean \code{force_delim} distinguishes between 
two splitting modes:

\enumerate{

  \item If \code{force_delim = FALSE} (as per default), 
  the function assumes a standard sentence-splitting pattern: 
  A sentence delimiter in \code{split_delim} must be followed by 
  a single space and a capital letter starting the next sentence. 
  Sentence delimiters in \code{split_delim} are not removed 
  from the output.
  
  \item If \code{force_delim = TRUE}, 
  the function enforces splits at each delimiter in \code{split_delim}. 
  For instance, any dot (i.e., the metacharacter \code{"\\."}) is  
  interpreted as a full stop, so that sentences containing dots 
  mid-sentence (e.g., for abbreviations, etc.) are split into parts. 
  Sentence delimiters in \code{split_delim} are removed 
  from the output.
  
  }

Internally, \code{text_to_sentences} uses \code{\link{strsplit}} to 
split strings.
}
\examples{
x <- c("A first sentence. Exclamation sentence!", 
       "Any questions? But etc. can be tricky. A fourth --- and final --- sentence.")
text_to_sentences(x)
text_to_sentences(x, force_delim = TRUE)

# Changing split delimiters:
text_to_sentences(x, split_delim = "\\\\.")  # only split at "."

text_to_sentences("Buy apples, berries, and coconuts.")
text_to_sentences("Buy apples, berries; and coconuts.", 
                  split_delim = ",|;|\\\\.", force_delim = TRUE)
                  
text_to_sentences(c("123. 456? 789! 007 etc."), force_delim = TRUE)
text_to_sentences("Dr. Who is problematic.")


}
\seealso{
\code{\link{text_to_words}} for splitting text into a vector of words; 
\code{\link{count_words}} for counting the frequency of words; 
\code{\link{strsplit}} for splitting strings.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{l33t_rul35}},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()}
}
\concept{text objects and functions}
