% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{count_chars}
\alias{count_chars}
\title{Count the frequency of characters in a string of text \code{x}.}
\usage{
count_chars(x, case_sense = TRUE, rm_specials = TRUE, sort_freq = TRUE)
}
\arguments{
\item{x}{A string of text (required).}

\item{case_sense}{Boolean: Distinguish lower- vs. uppercase characters? 
Default: \code{case_sense = TRUE}.}

\item{rm_specials}{Boolean: Remove special characters? 
Default: \code{rm_specials = TRUE}.}

\item{sort_freq}{Boolean: Sort output by character frequency? 
Default: \code{sort_freq = TRUE}.}
}
\value{
A named numeric vector.
}
\description{
\code{count_chars} provides frequency counts of the 
characters in a string of text \code{x} 
as a named numeric vector.
}
\details{
If \code{rm_specials = TRUE} (as per default), 
most special (or non-word) characters are 
removed and not counted. (Note that this currently works 
without using regular expressions.)

The quantification is case-sensitive and the resulting  
vector is sorted by name (alphabetically) or 
by frequency (per default).
}
\examples{
# Default: 
x <- c("Hello world!", "This is a 1st sentence.", 
       "This is the 2nd sentence.", "THE END.")
count_chars(x)

# Options: 
count_chars(x, case_sense = FALSE)
count_chars(x, rm_specials = FALSE)
count_chars(x, sort_freq = FALSE)

}
\seealso{
\code{\link{count_words}} for counting the frequency of words; 
\code{\link{count_chars_words}} for counting both characters and words; 
\code{\link{plot_chars}} for a corresponding plotting function.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{chars_to_text}()},
\code{\link{collapse_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
