% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill31.R
\name{fill31}
\alias{fill31}
\title{Extending a daily time series to having 31 days each month.}
\usage{
fill31(x_ts, fill = "locf", to_ts = TRUE)
}
\arguments{
\item{x_ts}{Time series that will be extended to 31 days each month.}

\item{fill}{Method that is used to fill up time series. "locf": last observation carried forward, "lin": linear interpolation, "spline": spline interpolation.}

\item{to_ts}{Boolean. Determines format of the output series. Either ts or xts.}
}
\description{
This function extends a time series to have 31 days.
}
\details{
This function is used internally in dsa()
}
\examples{
x<-xts::xts(rnorm(1095, 100,1), seq.Date(as.Date("2009-01-01"), length.out=1095, by="days"))
a31 <- fill31(x)
a <- drop31(a31, 1, 365)
}
\author{
Daniel Ollech
}
