% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsem.R
\name{dsem_control}
\alias{dsem_control}
\title{Detailed control for dsem structure}
\usage{
dsem_control(
  nlminb_loops = 1,
  newton_loops = 1,
  trace = 0,
  eval.max = 1000,
  iter.max = 1000,
  getsd = TRUE,
  quiet = FALSE,
  run_model = TRUE,
  gmrf_parameterization = c("separable", "projection"),
  constant_variance = c("conditional", "marginal", "diagonal"),
  use_REML = TRUE,
  profile = NULL,
  parameters = NULL,
  map = NULL,
  getJointPrecision = FALSE,
  extra_convergence_checks = TRUE
)
}
\arguments{
\item{nlminb_loops}{Integer number of times to call \code{\link[stats]{nlminb}}.}

\item{newton_loops}{Integer number of Newton steps to do after running
\code{\link[stats]{nlminb}}.}

\item{trace}{Parameter values are printed every `trace` iteration
for the outer optimizer. Passed to
`control` in \code{\link[stats]{nlminb}}.}

\item{eval.max}{Maximum number of evaluations of the objective function
allowed. Passed to `control` in \code{\link[stats]{nlminb}}.}

\item{iter.max}{Maximum number of iterations allowed. Passed to `control` in
\code{\link[stats]{nlminb}}.}

\item{getsd}{Boolean indicating whether to call \code{\link[TMB]{sdreport}}}

\item{quiet}{Boolean indicating whether to run model printing messages to terminal or not;}

\item{run_model}{Boolean indicating whether to estimate parameters (the default), or
instead to return the model inputs and compiled TMB object without running;}

\item{gmrf_parameterization}{Parameterization to use for the Gaussian Markov 
random field, where the default `separable` constructs a precision matrix
that must be full rank, and the alternative `projection` constructs
a full-rank and IID precision for variables over time, and then projects
this using the inverse-cholesky of the precision, where this projection
can be rank-deficient.}

\item{constant_variance}{Whether to specify a constant conditional variance 
\eqn{ \mathbf{\Gamma \Gamma}^t} using the default \code{constant_variance="conditional"}, 
which results in a changing marginal variance      
along the specified causal graph when lagged paths are present. Alternatively, the user can
specify a constant marginal variance using \code{constant_variance="diagonal"}
or \code{constant_variance="marginal"},
such that \eqn{ \mathbf{\Gamma}} and \eqn{\mathbf{I-P}} are rescaled to achieve this constraint.  
All options
are equivalent when the model includes no lags (only simultaneous effects) and
no covariances (no two-headed arrows).  \code{"diagonal"} and \code{"marginal"}
are equivalent when the model includes no covariances. Given some exogenous covariance, 
\code{constant_variance = "marginal"} preserves the conditional correlation and has
changing conditional variance, while \code{constant_variance = "marginal"} has changing
conditional correlation along the causal graph.}

\item{use_REML}{Boolean indicating whether to treat non-variance fixed effects as random,
either to motigate bias in estimated variance parameters or improve efficiency for
parameter estimation given correlated fixed and random effects}

\item{profile}{Parameters to profile out of the likelihood (this subset will be appended to \code{random} with Laplace approximation disabled).}

\item{parameters}{list of fixed and random effects, e.g., as constructed by \code{dsem} and then modified
by hand (only helpful for advanced users to change starting values or restart at intended values)}

\item{map}{list of fixed and mirrored parameters, constructed by \code{dsem} by default but available
to override this default and then pass to \code{\link[TMB]{MakeADFun}}}

\item{getJointPrecision}{whether to get the joint precision matrix.  Passed
to \code{\link[TMB]{sdreport}}.}

\item{extra_convergence_checks}{Boolean indicating whether to run extra checks on model
convergence.}
}
\value{
An S3 object of class "dsem_control" that specifies detailed model settings,
allowing user specification while also specifying default values
}
\description{
Define a list of control parameters.  Note that
the format of this input is likely to change more rapidly than that of
\code{\link{dsem}}
}
