% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dnormhnorm.R
\name{dnormhnorm}
\alias{dnormhnorm}
\alias{normhnorm}
\alias{pnormhnorm}
\alias{qnormhnorm}
\alias{rnormhnorm}
\title{Normal-halfnormal distribution}
\usage{
dnormhnorm(
  x,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  deriv_order = 0,
  tri = NULL,
  log.p = FALSE
)

pnormhnorm(
  q,
  mu = 0,
  sigma_v = 1,
  sigma_u = 1,
  s = -1,
  deriv_order = 0,
  tri = NULL,
  log.p = FALSE
)

qnormhnorm(p, mu = 0, sigma_v = 1, sigma_u = 1, s = -1)

rnormhnorm(n, mu = 0, sigma_v = 1, sigma_u = 1, s = -1)
}
\arguments{
\item{x}{numeric vector of quantiles.}

\item{mu}{numeric vector of \eqn{\mu}.}

\item{sigma_v}{numeric vector of \eqn{\sigma_V}. Must be positive.}

\item{sigma_u}{numeric vector of \eqn{\sigma_U}. Must be positive.}

\item{s}{integer; \eqn{s=-1} for production and \eqn{s=1} for cost function.}

\item{deriv_order}{integer; maximum order of derivative. Available are \code{0},\code{2} and \code{4}.}

\item{tri}{optional; index matrix for upper triangular, generated by \code{\link[=trind_generator]{trind_generator()}}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{numeric vector of quantiles.}

\item{p}{numeric vector of probabilities.}

\item{n}{positive integer; number of observations.}
}
\value{
\code{dnormhnorm()} gives the density, \code{pnormhnorm()} give the distribution function, \code{qnormhnorm()} gives the quantile function, and \code{rnormhnorm()} generates random numbers, with given parameters.
\code{dnormhnorm()} and \code{pnormhnorm()} return a \code{derivs} object. For more details see \code{\link[=trind]{trind()}} and \code{\link[=trind_generator]{trind_generator()}}.
}
\description{
Probablitiy density function, distribution, quantile function and random number generation for the normal-halfnormal distribution
}
\details{
A random variable \eqn{X} follows a normal-halfnormal distribution if \eqn{X = V + s \cdot U }, where \eqn{V \sim N(\mu, \sigma_V^2)} and \eqn{U \sim HN(\sigma_U^2)}.
The density is given by \deqn{f_X(x)=\frac{1}{\sqrt{\sigma_V^2+\sigma_U^2}} \phi(\frac{x-\mu}{\sqrt{\sigma_V^2+\sigma_U^2}}) \Phi(s \frac{\sigma_U}{\sigma_V} \frac{x-\mu}{\sqrt{\sigma_V^2+\sigma_U^2}}) \qquad,}
where \eqn{s=-1} for production and \eqn{s=1} for cost function.
}
\section{Functions}{
\itemize{
\item \code{pnormhnorm()}: distribution function for the normal-halfnormal distribution.

\item \code{qnormhnorm()}: quantile function for the normal-halfnormal distribution.

\item \code{rnormhnorm()}: random number generation for the normal-halfnormal distribution.

}}
\examples{
pdf <- dnormhnorm(x=5, mu=1, sigma_v=2, sigma_u=3, s=-1)
cdf <- pnormhnorm(q=5, mu=1, sigma_v=2, sigma_u=3, s=-1)
q <- qnormhnorm(p=seq(0.1, 0.9, by=0.1), mu=1, sigma_v=2, sigma_u=3, s=-1)
r <- rnormhnorm(n=10, mu=1, sigma_v=2, sigma_u=3, s=-1)

}
\references{
\itemize{
\item \insertRef{aigner1977formulation}{dsfa}
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{schmidt2020analytic}{dsfa}
\item \insertRef{gradshteyn2014table}{dsfa}
\item \insertRef{azzalini2013skew}{dsfa}
}
}
\seealso{
Other distribution: 
\code{\link{dcomper_mv}()},
\code{\link{dcomper}()},
\code{\link{dnormexp}()}
}
\concept{distribution}
