% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDistance.R
\name{plotDistance}
\alias{plotDistance}
\title{Plotting distance maps}
\usage{
plotDistance(x, time.levels = 1, time.labels = 1, layers = NULL)
}
\arguments{
\item{x}{An object of class \code{\link[dtwSat]{twdtwRaster}}.}

\item{time.levels}{A \link[base]{character} or \link[base]{numeric}
vector with the layers to plot. For plot type ''change'' the minimum length 
is two.}

\item{time.labels}{A \link[base]{character} or \link[base]{numeric}
vector with the labels of the layers. It must have the same 
length as time.levels. Default is NULL.}

\item{layers}{A \link[base]{character} or \link[base]{numeric}
vector with the layers/bands of the raster time series.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Method for plotting TWDTW distance maps.
}
\examples{
\dontrun{
# Run TWDTW analysis for raster time series 
patt = MOD13Q1.MT.yearly.patterns
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
ndvi = brick(system.file("lucc_MT/data/ndvi.tif", package="dtwSat"))
red = brick(system.file("lucc_MT/data/red.tif", package="dtwSat"))
blue = brick(system.file("lucc_MT/data/blue.tif", package="dtwSat"))
nir = brick(system.file("lucc_MT/data/nir.tif", package="dtwSat"))
mir = brick(system.file("lucc_MT/data/mir.tif", package="dtwSat"))
doy = brick(system.file("lucc_MT/data/doy.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
rts = twdtwRaster(evi, ndvi, red, blue, nir, mir, timeline = timeline, doy = doy)

time_interval = seq(from=as.Date("2007-09-01"), to=as.Date("2013-09-01"), 
                    by="12 month")
log_fun = weight.fun=logisticWeight(-0.1,50)

r_twdtw = twdtwApply(x=rts, y=patt, weight.fun=log_fun, breaks=time_interval, 
          filepath="~/test_twdtw", overwrite=TRUE, format="GTiff", mc.cores=3)

plotDistance(r_twdtw)

}
}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwRaster-class}},
\code{\link[dtwSat]{twdtwApply}}, 
\code{\link[dtwSat]{plotArea}}, 
\code{\link[dtwSat]{plotChanges}}, and
\code{\link[dtwSat]{plotDistance}}.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
