% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPaths.R
\name{plotPaths}
\alias{plotPaths}
\title{Plotting paths}
\usage{
plotPaths(x, timeseries.labels = NULL, patterns.labels = NULL, k = NULL)
}
\arguments{
\item{x}{An object of class \code{\link[dtwSat]{twdtwMatches}}.}

\item{timeseries.labels}{The label or index of the time series.
Default is 1.}

\item{patterns.labels}{A vector with labels of the patterns. If not 
declared the function will plot one alignment for each pattern.}

\item{k}{A positive integer. The index of the last alignment to include in 
the plot. If not declared the function will plot all low cost paths.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Method for plotting low cost paths in the TWDTW 
cost matrix.
}
\examples{
log_fun = logisticWeight(-0.1, 100)
ts = twdtwTimeSeries(MOD13Q1.ts.list)
patt = twdtwTimeSeries(MOD13Q1.patterns.list)
mat1 = twdtwApply(x=ts, y=patt, weight.fun=log_fun, keep=TRUE, legacy=TRUE)

plotPaths(mat1)

plotPaths(mat1, patterns.labels="Soybean", k=1:2)

plotPaths(mat1, patterns.labels=c("Maize","Cotton"), k=2)

}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwMatches-class}}, 
\code{\link[dtwSat]{twdtwApply}}, 
\code{\link[dtwSat]{plotAlignments}}, 
\code{\link[dtwSat]{plotCostMatrix}},
\code{\link[dtwSat]{plotMatches}}, and
\code{\link[dtwSat]{plotClassification}}.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
