% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsclust-methods.R
\docType{methods}
\name{tsclusters-methods}
\alias{tsclusters-methods}
\alias{initialize,TSClusters-method}
\alias{initialize,TSClusters}
\alias{show,TSClusters-method}
\alias{show,TSClusters}
\alias{update.TSClusters}
\alias{update,TSClusters-method}
\alias{update,TSClusters}
\alias{predict.TSClusters}
\alias{predict,TSClusters-method}
\alias{predict,TSClusters}
\alias{plot.TSClusters}
\alias{plot,TSClusters,missing-method}
\alias{plot,TSClusters,missing}
\title{Methods for \code{TSClusters}}
\usage{
\S4method{initialize}{TSClusters}(.Object, ..., override.family = TRUE)

\S4method{show}{TSClusters}(object)

\method{update}{TSClusters}(object, ..., evaluate = TRUE)

\S4method{update}{TSClusters}(object, ..., evaluate = TRUE)

\method{predict}{TSClusters}(object, newdata = NULL, ...)

\S4method{predict}{TSClusters}(object, newdata = NULL, ...)

\method{plot}{TSClusters}(x, y, ..., clus = seq_len(x@k), labs.arg = NULL,
  series = NULL, time = NULL, plot = TRUE, type = NULL)

\S4method{plot}{TSClusters,missing}(x, y, ..., clus = seq_len(x@k),
  labs.arg = NULL, series = NULL, time = NULL, plot = TRUE,
  type = NULL)
}
\arguments{
\item{.Object}{A \code{TSClusters} prototype. You shouldn't use this, see Initialize section and the
examples.}

\item{...}{For \code{initialize}, any valid slots. For \code{plot}, further arguments to pass to
\code{\link[ggplot2:geom_line]{ggplot2::geom_line()}} for the plotting of the \emph{cluster centroids}, or to
\code{\link[stats:plot.hclust]{stats::plot.hclust()}}. See Plotting section. For \code{update}, any supported argument. Otherwise
ignored.}

\item{override.family}{Logical. Attempt to substitute the default family with one that conforms
to the provided elements? See Initialize section.}

\item{object, x}{An object that inherits from \linkS4class{TSClusters} as returned by \code{\link[=tsclust]{tsclust()}}.}

\item{evaluate}{Logical. Defaults to \code{TRUE} and evaluates the updated call, which will result in
a new \code{TSClusters} object. Otherwise, it returns the unevaluated call.}

\item{newdata}{New data to be assigned to a cluster. It can take any of the supported formats of
\code{\link[=tsclust]{tsclust()}}. Note that for multivariate series, this means that it \strong{must} be a list of
matrices, even if the list has only one element.}

\item{y}{Ignored.}

\item{clus}{A numeric vector indicating which clusters to plot.}

\item{labs.arg}{Arguments to change the title and/or axis labels. See \code{\link[ggplot2:labs]{ggplot2::labs()}} for more
information}

\item{series}{Optionally, the data in the same format as it was provided to \code{\link[=tsclust]{tsclust()}}.}

\item{time}{Optional values for the time axis. If series have different lengths, provide the time
values of the longest series.}

\item{plot}{Logical flag. You can set this to \code{FALSE} in case you want to save the ggplot object
without printing anything to screen}

\item{type}{What to plot. \code{NULL} means default. See details.}
}
\value{
The plot method returns a \code{gg} object (or \code{NULL} for dendrogram plot) invisibly.
}
\description{
Methods associated with \linkS4class{TSClusters} and derived objects.
}
\details{
The \code{update} method takes the original function call, replaces any provided argument and
optionally evaluates the call again. Use \code{evaluate = FALSE} if you want to get the unevaluated
call. If no arguments are provided, the object is updated to a new version if necessary (this is
due to changes in the internal functions of the package, here for backward compatibility).

The \code{predict} generic can take the usual \code{newdata} argument and it returns the cluster(s) to
which the data belongs; if \code{NULL}, it simply returns the obtained cluster indices. It
preprocesses the data with the corresponding function if available.
}
\section{Initialize}{


The initialize method is used when calling \code{\link[methods:new]{methods::new()}}. The \code{family} slot can be
substituted with an appropriate one if certain elements are provided by the user. The
initialize methods of derived classes also inherit the family and can use it to calculate other
slots. In order to get a fully functional object, at least the following slots should be
provided:
\itemize{
\item \code{type}: "partitional", "hierarchical", "fuzzy" or "tadpole".
\item \code{datalist}: The data in one of the supported formats.
\item \code{centroids}: The time series centroids in one of the supported formats.
\item \code{cluster}: The cluster indices for each series in the \code{datalist}.
\item \code{control*}: A \link{tsclust-controls} object with the desired parameters.
\item \code{distance*}: A string indicating the distance that should be used.
\item \code{centroid*}: A string indicating the centroid to use (only necessary for partitional
clustering).
}

*Necessary when overriding the default family for the calculation of other slots, CVIs or
prediction. Maybe not always needed, e.g. for plotting.
}

\section{Plotting}{


The plot method uses the \code{ggplot2} plotting system (see \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}).

The default depends on whether a hierarchical method was used or not. In those cases, the
dendrogram is plotted by default; you can pass any extra parameters to \code{\link[stats:plot.hclust]{stats::plot.hclust()}}
via \code{...}.

Otherwise, the function plots the time series of each cluster along with the obtained centroid.
The default values for cluster centroids are: \code{linetype = "dashed"}, \code{size = 1.5}, \code{colour = "black"}, \code{alpha = 0.5}. You can change this by means of \code{...}.

You can choose what to plot with the \code{type} parameter. Possible options are:
\itemize{
\item \code{"dendrogram"}: Only available for hierarchical clustering.
\item \code{"series"}: Plot the time series divided into clusters without including centroids.
\item \code{"centroids"}: Plot the obtained centroids only.
\item \code{"sc"}: Plot both series and centroids
}

If created, the function returns the \code{gg} object invisibly, in case you want to modify it to
your liking. You might want to look at \code{\link[ggplot2:ggplot_build]{ggplot2::ggplot_build()}} if that's the case.

If you want to free the scale of the X axis, you can do the following:

\code{plot(object, plot = FALSE)} \code{+} \code{facet_wrap(~cl, scales = "free")}
}

\examples{

data(uciCT)

# Assuming this was generated by some clustering procedure
centroids <- CharTraj[seq(1L, 100L, 5L)]
cluster <- unclass(CharTrajLabels)

pc_obj <- new("PartitionalTSClusters",
              type = "partitional", datalist = CharTraj,
              centroids = centroids, cluster = cluster,
              distance = "sbd", centroid = "dba",
              control = partitional_control(),
              args = tsclust_args(cent = list(window.size = 8L, norm = "L2")))

fc_obj <- new("FuzzyTSClusters",
              type = "fuzzy", datalist = CharTraj,
              centroids = centroids, cluster = cluster,
              distance = "sbd", centroid = "fcm",
              control = fuzzy_control())

fc_obj

}
