% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare-clusterings.R
\name{pdc_configs}
\alias{pdc_configs}
\title{Helper function for preprocessing/distance/centroid configurations}
\usage{
pdc_configs(type = c("preproc", "distance", "centroid"), ...,
  partitional = NULL, hierarchical = NULL, fuzzy = NULL, tadpole = NULL,
  share.config = c("p", "h", "f", "t"))
}
\arguments{
\item{type}{Which type of function is being targeted by this configuration.}

\item{...}{Any number of named nested lists with functions and arguments that will be shared by
all clusterings. See details.}

\item{partitional}{A named list of lists with functions and arguments for partitional
clusterings.}

\item{hierarchical}{A named list of lists with functions and arguments for hierarchical
clusterings.}

\item{fuzzy}{A named list of lists with functions and arguments for fuzzy clusterings.}

\item{tadpole}{A named list of lists with functions and arguments for TADPole clusterings.}

\item{share.config}{A character vector specifying which clusterings should include the shared
lists (the ones specified in \code{...}). It must be any combination of (possibly abbreviated):
partitional, hierarchical, fuzzy, tadpole.}
}
\value{
A list for each clustering, each of which includes a data frame with the computed configurations.
}
\description{
Create preprocessing, distance and centroid configurations for \code{\link[=compare_clusterings_configs]{compare_clusterings_configs()}}.
All functions use \code{\link[base:expand.grid]{base::expand.grid()}}.
}
\details{
The named lists are interpreted in the following way: the name of each element of the list will
be considered to be a function name, and the elements of the nested list will be the possible
parameters for the function. Each function must have at least an empty list. The parameters may
be vectors that specify different values to be tested.

For preprocessing, the special name \code{none} signifies no preprocessing.

For centroids, the special name \code{default} leaves the centroid unspecified.

Please see the examples in \code{\link[=compare_clusterings]{compare_clusterings()}} to see how this is used.
}
