% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R
\docType{class}
\name{duckdb_result-class}
\alias{duckdb_result-class}
\alias{duckdb_result}
\alias{show,duckdb_result-method}
\alias{dbClearResult,duckdb_result-method}
\alias{duckdb_fetch_arrow}
\alias{duckdb_fetch_record_batch}
\alias{dbFetch,duckdb_result-method}
\alias{dbHasCompleted,duckdb_result-method}
\alias{dbGetInfo,duckdb_result-method}
\alias{dbIsValid,duckdb_result-method}
\alias{dbGetStatement,duckdb_result-method}
\alias{dbColumnInfo,duckdb_result-method}
\alias{dbGetRowCount,duckdb_result-method}
\alias{dbGetRowsAffected,duckdb_result-method}
\alias{dbBind,duckdb_result-method}
\title{DuckDB Result Set}
\usage{
\S4method{show}{duckdb_result}(object)

\S4method{dbClearResult}{duckdb_result}(res, ...)

duckdb_fetch_arrow(
  res,
  stream = FALSE,
  vector_per_chunk = 1,
  return_table = FALSE
)

duckdb_fetch_record_batch(res)

\S4method{dbFetch}{duckdb_result}(res, n = -1, ...)

\S4method{dbHasCompleted}{duckdb_result}(res, ...)

\S4method{dbGetInfo}{duckdb_result}(dbObj, ...)

\S4method{dbIsValid}{duckdb_result}(dbObj, ...)

\S4method{dbGetStatement}{duckdb_result}(res, ...)

\S4method{dbColumnInfo}{duckdb_result}(res, ...)

\S4method{dbGetRowCount}{duckdb_result}(res, ...)

\S4method{dbGetRowsAffected}{duckdb_result}(res, ...)

\S4method{dbBind}{duckdb_result}(res, params, ...)
}
\arguments{
\item{object}{Any R object}

\item{res}{Query result to be converted to an Arrow Table}

\item{...}{Other arguments passed on to methods.}

\item{stream}{If we are streaming the query result or returning it all at once}

\item{vector_per_chunk}{If streaming, how many vectors per chunk we should emit}

\item{return_table}{If we return results as a list of RecordBatches or an Arrow Table}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{params}{A list of bindings, named or unnamed.}
}
\description{
Methods for accessing result sets for queries on DuckDB connections.
Implements \linkS4class{DBIResult}.
}
\keyword{internal}
