# Generated by 03-tests.R

withr::local_envvar(DUCKPLYR_FORCE = "TRUE")

meta <- testthat::is_parallel() # Slow!
# meta <- TRUE

test_that("as_duckplyr_df() and add_count()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% add_count()
  post <- test_df %>% add_count() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and add_count()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% add_count()
  post <- test_df %>% add_count() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and anti_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% anti_join(test_df_y, join_by(a))
  post <- test_df_x %>% anti_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and anti_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% anti_join(test_df_y, join_by(a))
  post <- test_df_x %>% anti_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and arrange()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange()
  post <- test_df %>% arrange() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and arrange()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange()
  post <- test_df %>% arrange() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and arrange(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange(a)
  post <- test_df %>% arrange(a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and arrange(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange(g)
  post <- test_df %>% arrange(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and arrange(g, a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange(g, a)
  post <- test_df %>% arrange(g, a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and arrange(a, g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% arrange(a, g)
  post <- test_df %>% arrange(a, g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and auto_copy()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% auto_copy(test_df_y)
  post <- test_df_x %>% auto_copy(test_df_y)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and auto_copy()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% auto_copy(test_df_y)
  post <- test_df_x %>% auto_copy(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and collapse()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% collapse()
  post <- test_df %>% collapse() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and collapse()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% collapse()
  post <- test_df %>% collapse() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and collect()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% collect()
  post <- test_df %>% collect() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and collect()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% collect()
  post <- test_df %>% collect() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and compute()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% compute()
  post <- test_df %>% compute() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and compute()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% compute()
  post <- test_df %>% compute() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and count()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count()
  post <- test_df %>% count() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count()
  post <- test_df %>% count() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(a)
  post <- test_df %>% count(a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(b)
  post <- test_df %>% count(b) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(g)
  post <- test_df %>% count(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(g, a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(g, a)
  post <- test_df %>% count(g, a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and count(b, g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% count(b, g)
  post <- test_df %>% count(b, g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and cross_join()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% cross_join(test_df_y)
  post <- test_df_x %>% cross_join(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and cross_join()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% cross_join(test_df_y)
  post <- test_df_x %>% cross_join(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and distinct()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct()
  post <- test_df %>% distinct() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct()
  post <- test_df %>% distinct() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(a)
  post <- test_df %>% distinct(a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(a, b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(a, b)
  post <- test_df %>% distinct(a, b) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(b, b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(b, b)
  post <- test_df %>% distinct(b, b) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(g)
  post <- test_df %>% distinct(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g)
  post <- test_df %>% union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and distinct(g, .keep_all = TRUE)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% distinct(g, .keep_all = TRUE)
  post <- test_df %>% distinct(g, .keep_all = TRUE) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and do(data.frame(c = 1))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% do(data.frame(c = 1))
  post <- test_df %>% do(data.frame(c = 1))

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and do(data.frame(c = 1))", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% do(data.frame(c = 1))
  post <- test_df %>% do(data.frame(c = 1))

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and dplyr_reconstruct(test_df)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Hack")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% dplyr_reconstruct(test_df)
  post <- test_df %>% dplyr_reconstruct(test_df)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and filter(a == 1)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% filter(a == 1)
  post <- test_df %>% filter(a == 1) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and filter(a == 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% filter(a == 1)
  post <- test_df %>% filter(a == 1) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and filter(a %in% 2:3, g == 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% filter(a %in% 2:3, g == 2)
  post <- test_df %>% filter(a %in% 2:3, g == 2) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and filter(a %in% 2:3 & g == 2)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% filter(a %in% 2:3 & g == 2)
  post <- test_df %>% filter(a %in% 2:3 & g == 2) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and full_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% full_join(test_df_y, join_by(a))
  post <- test_df_x %>% full_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and full_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% full_join(test_df_y, join_by(a))
  post <- test_df_x %>% full_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and group_vars()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% group_vars()
  post <- test_df %>% group_vars()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and group_vars()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% group_vars()
  post <- test_df %>% group_vars()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and inner_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% inner_join(test_df_y, join_by(a))
  post <- test_df_x %>% inner_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and inner_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% inner_join(test_df_y, join_by(a))
  post <- test_df_x %>% inner_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and intersect()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% intersect(test_df_y)
  post <- test_df_x %>% intersect(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and intersect()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% intersect(test_df_y)
  post <- test_df_x %>% intersect(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and left_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% left_join(test_df_y, join_by(a))
  post <- test_df_x %>% left_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and left_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% left_join(test_df_y, join_by(a))
  post <- test_df_x %>% left_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and mutate()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate()
  post <- test_df %>% mutate() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate()
  post <- test_df %>% mutate() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(a + 1)
  post <- test_df %>% mutate(a + 1) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(a + 1, .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(a + 1, .by = g)
  post <- test_df %>% mutate(a + 1, .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(c = a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(c = a + 1)
  post <- test_df %>% mutate(c = a + 1) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(`if` = a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(`if` = a + 1)
  post <- test_df %>% mutate(`if` = a + 1) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(sum(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(sum(a))
  post <- test_df %>% mutate(sum(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(sum(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(sum(a), .by = g)
  post <- test_df %>% mutate(sum(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(mean(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(mean(a))
  post <- test_df %>% mutate(mean(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(mean(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(mean(a), .by = g)
  post <- test_df %>% mutate(mean(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(sd(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(sd(a))
  post <- test_df %>% mutate(sd(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(sd(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(sd(a), .by = g)
  post <- test_df %>% mutate(sd(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a))
  post <- test_df %>% mutate(lag(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a), .by = g)
  post <- test_df %>% mutate(lag(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a))
  post <- test_df %>% mutate(lead(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a), .by = g)
  post <- test_df %>% mutate(lead(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, 2))
  post <- test_df %>% mutate(lag(a, 2)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, 2), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, 2), .by = g)
  post <- test_df %>% mutate(lag(a, 2), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, 2))
  post <- test_df %>% mutate(lead(a, 2)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, 2), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, 2), .by = g)
  post <- test_df %>% mutate(lead(a, 2), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, 4))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, 4))
  post <- test_df %>% mutate(lag(a, 4)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, 4), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, 4), .by = g)
  post <- test_df %>% mutate(lag(a, 4), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, 4))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, 4))
  post <- test_df %>% mutate(lead(a, 4)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, 4), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, 4), .by = g)
  post <- test_df %>% mutate(lead(a, 4), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, default = 0))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, default = 0))
  post <- test_df %>% mutate(lag(a, default = 0)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lag(a, default = 0), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lag(a, default = 0), .by = g)
  post <- test_df %>% mutate(lag(a, default = 0), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, default = 1000))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, default = 1000))
  post <- test_df %>% mutate(lead(a, default = 1000)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(lead(a, default = 1000), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(lead(a, default = 1000), .by = g)
  post <- test_df %>% mutate(lead(a, default = 1000), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(min(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(min(a))
  post <- test_df %>% mutate(min(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(min(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(min(a), .by = g)
  post <- test_df %>% mutate(min(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(max(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(max(a))
  post <- test_df %>% mutate(max(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(max(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(max(a), .by = g)
  post <- test_df %>% mutate(max(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(first(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(first(a))
  post <- test_df %>% mutate(first(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(first(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(first(a), .by = g)
  post <- test_df %>% mutate(first(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(last(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(last(a))
  post <- test_df %>% mutate(last(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(last(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(last(a), .by = g)
  post <- test_df %>% mutate(last(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(nth(a, 2))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(nth(a, 2))
  post <- test_df %>% mutate(nth(a, 2)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(nth(a, 2), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(nth(a, 2), .by = g)
  post <- test_df %>% mutate(nth(a, 2), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(a / b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(a / b)
  post <- test_df %>% mutate(a / b) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and mutate(c = 0, d = 0, e = c / d)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% mutate(c = 0, d = 0, e = c / d)
  post <- test_df %>% mutate(c = 0, d = 0, e = c / d) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and nest_by()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("WAT")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% nest_by()
  post <- test_df %>% nest_by() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and nest_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% nest_join(test_df_y, join_by(a))
  post <- test_df_x %>% nest_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and nest_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% nest_join(test_df_y, join_by(a))
  post <- test_df_x %>% nest_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and pull()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% pull()
  post <- test_df %>% pull()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and pull()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% pull()
  post <- test_df %>% pull()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and reframe()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% reframe()
  post <- test_df %>% reframe()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and reframe()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% reframe()
  post <- test_df %>% reframe()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and relocate(g)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% relocate(g)
  post <- test_df %>% relocate(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and relocate(g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% relocate(g)
  post <- test_df %>% relocate(g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and relocate(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% relocate(a)
  post <- test_df %>% relocate(a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and relocate(g, .before = b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% relocate(g, .before = b)
  post <- test_df %>% relocate(g, .before = b) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and relocate(a:b, .after = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% relocate(a:b, .after = g)
  post <- test_df %>% relocate(a:b, .after = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rename()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% rename()
  post <- test_df %>% rename() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rename()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% rename()
  post <- test_df %>% rename() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rename(c = a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% rename(c = a)
  post <- test_df %>% rename(c = a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rename_with(identity)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% rename_with(identity)
  post <- test_df %>% rename_with(identity) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rename_with(identity)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% rename_with(identity)
  post <- test_df %>% rename_with(identity) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and right_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% right_join(test_df_y, join_by(a))
  post <- test_df_x %>% right_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and right_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% right_join(test_df_y, join_by(a))
  post <- test_df_x %>% right_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_append()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_append(test_df_y)
  post <- test_df_x %>% rows_append(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rows_append()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_append(test_df_y)
  post <- test_df_x %>% rows_append(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_delete(by = c(\"a\", \"b\"), unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore")
  post <- test_df_x %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rows_delete(by = c(\"a\", \"b\"), unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore")
  post <- test_df_x %>% rows_delete(test_df_y, by = c("a", "b"), unmatched = "ignore") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_insert(by = \"a\", conflict = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_insert(test_df_y, by = "a", conflict = "ignore")
  post <- test_df_x %>% rows_insert(test_df_y, by = "a", conflict = "ignore") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rows_insert(by = \"a\", conflict = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_insert(test_df_y, by = "a", conflict = "ignore")
  post <- test_df_x %>% rows_insert(test_df_y, by = "a", conflict = "ignore") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_patch(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_patch(test_df_y, by = "a", unmatched = "ignore")
  post <- test_df_x %>% rows_patch(test_df_y, by = "a", unmatched = "ignore") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rows_patch(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_patch(test_df_y, by = "a", unmatched = "ignore")
  post <- test_df_x %>% rows_patch(test_df_y, by = "a", unmatched = "ignore") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_update(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_update(test_df_y, by = "a", unmatched = "ignore")
  post <- test_df_x %>% rows_update(test_df_y, by = "a", unmatched = "ignore") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rows_update(by = \"a\", unmatched = \"ignore\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_update(test_df_y, by = "a", unmatched = "ignore")
  post <- test_df_x %>% rows_update(test_df_y, by = "a", unmatched = "ignore") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and rows_upsert(by = \"a\")", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_upsert(test_df_y, by = "a")
  post <- test_df_x %>% rows_upsert(test_df_y, by = "a") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and rows_upsert(by = \"a\")", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% rows_upsert(test_df_y, by = "a")
  post <- test_df_x %>% rows_upsert(test_df_y, by = "a") %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and sample_frac()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Random seed")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% sample_frac()
  post <- test_df %>% sample_frac() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and sample_n(size = 1)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Random seed")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% sample_n(size = 1)
  post <- test_df %>% sample_n(size = 1) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and select(a)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% select(a)
  post <- test_df %>% select(a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and select(a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% select(a)
  post <- test_df %>% select(a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and select(-g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% select(-g)
  post <- test_df %>% select(-g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and select(everything())", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% select(everything())
  post <- test_df %>% select(everything()) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and semi_join(join_by(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% semi_join(test_df_y, join_by(a))
  post <- test_df_x %>% semi_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and semi_join(join_by(a))", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% semi_join(test_df_y, join_by(a))
  post <- test_df_x %>% semi_join(test_df_y, join_by(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and setdiff()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% setdiff(test_df_y)
  post <- test_df_x %>% setdiff(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and setdiff()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% setdiff(test_df_y)
  post <- test_df_x %>% setdiff(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and setequal()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% setequal(test_df_y)
  post <- test_df_x %>% setequal(test_df_y)

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and setequal()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% setequal(test_df_y)
  post <- test_df_x %>% setequal(test_df_y)

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice()
  post <- test_df %>% slice() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and slice()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice()
  post <- test_df %>% slice() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_head()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_head()
  post <- test_df %>% slice_head() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_max(a)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_max(a)
  post <- test_df %>% slice_max(a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_min(a)", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_min(a)
  post <- test_df %>% slice_min(a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_sample()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_sample()
  post <- test_df %>% slice_sample() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and slice_tail()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("External vector?")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% slice_tail()
  post <- test_df %>% slice_tail() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and summarise(c = mean(a))", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = mean(a))
  post <- test_df %>% summarise(c = mean(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and summarise(c = mean(a))", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = mean(a))
  post <- test_df %>% summarise(c = mean(a)) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and summarise(c = mean(a), .by = b)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = mean(a), .by = b)
  post <- test_df %>% summarise(c = mean(a), .by = b) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and summarise(c = mean(a), .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = mean(a), .by = g)
  post <- test_df %>% summarise(c = mean(a), .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and summarise(c = 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = 1)
  post <- test_df %>% summarise(c = 1) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and summarise(c = 1, .by = g)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% summarise(c = 1, .by = g)
  post <- test_df %>% summarise(c = 1, .by = g) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and symdiff()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% symdiff(test_df_y)
  post <- test_df_x %>% symdiff(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and symdiff()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% symdiff(test_df_y)
  post <- test_df_x %>% symdiff(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and tally()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% tally()
  post <- test_df %>% tally() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and tally()", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% tally()
  post <- test_df %>% tally() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and tbl_vars()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% tbl_vars()
  post <- test_df %>% tbl_vars()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and tbl_vars()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% tbl_vars()
  post <- test_df %>% tbl_vars()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and transmute(c = a + 1)", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% transmute(c = a + 1)
  post <- test_df %>% transmute(c = a + 1) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and transmute(c = a + 1)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% transmute(c = a + 1)
  post <- test_df %>% transmute(c = a + 1) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and transmute(row = a)", {
  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% transmute(row = a)
  post <- test_df %>% transmute(row = a) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and ungroup()", {
  withr::local_envvar(DUCKPLYR_FORCE = "FALSE")

  skip("Grouped")

  # Data
  test_df <- data.frame(a = 1:6 + 0, b = 2, g = rep(1:3, 1:3))

  # Run
  pre <- test_df %>% as_duckplyr_df() %>% ungroup()
  post <- test_df %>% ungroup() %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and union()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% union(test_df_y)
  post <- test_df_x %>% union(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% union(test_df_y)
  post <- test_df_x %>% union(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})

test_that("as_duckplyr_df() and union_all()", {
  withr::local_envvar(DUCKPLYR_FALLBACK_FORCE = "TRUE")

  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% union_all(test_df_y)
  post <- test_df_x %>% union_all(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})


test_that("as_duckplyr_df() and union_all()", {
  # Data
  test_df_x <- data.frame(a = 1:4, b = 2)
  test_df_y <- data.frame(a = 2:5, b = 2)

  # Run
  pre <- test_df_x %>% as_duckplyr_df() %>% union_all(test_df_y)
  post <- test_df_x %>% union_all(test_df_y) %>% as_duckplyr_df()

  # Compare
  expect_equal(pre, post)
})
