% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{log_filter}
\alias{log_filter}
\alias{log_filter.data.frame}
\alias{log_filter.list}
\title{Filter Data with Log}
\usage{
log_filter(data, condition, ...)

\method{log_filter}{data.frame}(data, condition, suffix = NULL, ...)

\method{log_filter}{list}(
  data,
  condition,
  table,
  by = c("USUBJID", "STUDYID"),
  suffix = NULL,
  ...
)
}
\arguments{
\item{data}{(\code{data.frame}) input data to subset, or named (\code{list} of \code{data.frame}).}

\item{condition}{(\code{call}) of subset condition. Must evaluate as logical.}

\item{...}{further arguments to be passed to or from other methods.}

\item{suffix}{(\code{string}) optional argument describing the filter.}

\item{table}{(\code{string}) table name.}

\item{by}{(\code{character}) variable names shared by \code{adsl} and other datasets for filtering.}
}
\value{
a \code{data.frame} or \code{list} of \code{data.frame} filtered for the provided conditions.
}
\description{
Filter Data with Log
}
\details{
\code{log_filter} will filter the data/named list of data according to the \code{condition}.
All the variables in \code{condition} must exist in the data (as variables) or in the parent
frame(e.g., in global environment).
For named list of data, if \code{ADSL} is available, \code{log_filter} will also try to subset all
other datasets with \code{USUBJID}.
}
\examples{
data <- iris
attr(data$Sepal.Length, "label") <- "cm"
log_filter(data, Sepal.Length >= 7)

log_filter(list(iris = iris), Sepal.Length >= 7, "iris", character(0))
}
