% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{mphcrm}
\alias{mphcrm}
\title{Estimate a mixed proportional hazard model}
\usage{
mphcrm(
  formula,
  data,
  risksets = NULL,
  timing = c("exact", "interval", "none"),
  subset,
  na.action,
  control = mphcrm.control()
)
}
\arguments{
\item{formula}{A formula specifying the covariates.
In a formula like \code{d ~ x1 + x2 + ID(id) + D(dur) + C(job,alpha) + S(state)},
the \code{d} is the transition which is taken, coded as an integer where \code{0} means
no transition, and otherwise \code{d} is the number of the transition which is taken.
\code{d} can also be a factor, in which case the level which is no transition must be named
\code{"0"} or \code{"none"}. If \code{d} is an integer, the levels for transitions will be named
\code{"t1"}, \code{"t2"}, ..., and \code{"none"}.

The \code{x1+x2} part is like in \code{\link{lm}}, i.e. ordinary covariates or factors.

The \code{D()} specifies the covariate which holds the duration of each observation. The
transition in \code{d} is assumed to be taken at the end of this period.

The \code{ID()} part specifies the covariate which holds the individual identification.

The \code{S()} specifies the covariate which holds an index into the \code{risksets} list.

These three special symbols are replaced with \code{I()}, so it is possible to have calculations
inside them.

If the covariates differ among the transitions, one can specify covariates conditional on
the transition taken. If e.g. the covariates \code{alpha} and \code{x3} should only explain transition to
job, specify \code{C(job, alpha+x3)}. This comes in addition to the ordinary covariates.
The name "\code{job}" refers to a level in the factor \code{d}, the transition taken.}

\item{data}{A data frame which contains the covariates. It must be sorted on individuals.}

\item{risksets}{A list of character vectors. Each vector is a list of transitions, i.e. which risks are present for
the observation. The elements of the vectors must be levels of the covariate which is the
left hand side of the \code{formula}.
If the state variable in the formula is a factor, the \code{risksets} argument should be a named list, with
names matching the levels of \code{state}. If all risks are present at all times, the \code{risksets}-argument
can be specified as \code{NULL}, or ignored.}

\item{timing}{character. The timing in the duration model. Can be one of
\itemize{
\item \code{"exact"}. The timing is exact, the transition occured at the end of the observation interval.
\item \code{"interval"}. The transition occured some time during the observation interval. This model
  can be notoriously hard to estimate due to unfavourable numerics. 
\item \code{"none"}. There is no timing, the transition occured, or not. A logit model is used.
}}

\item{subset}{For specifying a subset of the dataset, similar to \code{\link{lm}}.}

\item{na.action}{For handling of missing cases, similar to \code{\link{lm}}.}

\item{control}{List of control parameters for the estimation. See \code{\link{mphcrm.control}}.}
}
\value{
A list, one entry for each iteration. Ordered in reverse order. Ordinarily you will be
interested in the first entry.
}
\description{
\code{mphcrm} implements estimation of a mixed proportional hazard competing risk model.
The baseline hazard is of the form \eqn{exp(X \beta)} where \eqn{X} is a
matrix of covariates, and \eqn{\beta} is a vector of parameters to estimate.
In addition there is an intercept term \eqn{\mu}, i.e. the hazard is \eqn{exp(X \beta + \mu)}.
There are several transitions to be made, and a set of \eqn{X}, \eqn{\beta}, and \eqn{\mu} for
each possible transition.

Each individual may have several observations, with either a transition at the end of the
observation, or not a transition. It is a competing risk, there can be more than one possible
transition for an observation, but only one is taken at the end of the period.

For each individual \eqn{i} there is a log likelihood as a function of \eqn{\mu}, called \eqn{M_i(\mu)}.

The mixture part is that the \eqn{\mu}'s are stochastic. I.e. 
we have probabilities \eqn{p_j}, and a vector of \eqn{\mu_j} of masspoints (one for each transition),
for each such \eqn{j}.

So the full likelihood for an individual is \eqn{L_i = \sum_j p_j M_i(\mu_j)}.

The \code{mphcrm()} function maximizes the likelihood \eqn{\sum_i L_i} over
\eqn{p_j}, \eqn{\mu_j}, and \eqn{\beta}.

In addition to the covariates specified by a formula, a variable which records the duration of each
observation must be specified.

In some datasets it is known that not all risks are present at all times. Like, losing your
job when you do not have one. In this case it should be specified which risks are present.

The estimation starts out with one masspoint, maximizes the likelihood, tries to add another
point, and continues in this fashion.
}
\details{
The estimation starts by estimating the null-model, i.e. all parameters set to 0, only one
intercept for each transition is estimated.

Then it estimates the full model, still with one intercept in each transition.

After the initial model has been estimated, it tries to add a masspoint to the mixing
distribution, then estimates the model with this new distribution.

The algorithm continues to add masspoints in this way until either it can not improve the likelihood, or
the number of iterations as specified in \code{control$iters} are reached.

The result of every iteration is returned in a list.

If you interrupt \code{mphcrm} it will catch the interrupt and return with the
estimates it has found so far. This behaviour can be switched off with \code{control$trap.interrupt=FALSE}.
}
\note{
The algorithm is not fully deterministic. New points are searched for randomly, there
is no canonical order in which they can be found. It can happen that a point is found
early which makes the rest of the estimation hard, so it terminates early. In particular
when using interval timing. One should then
make a couple of runs to ensure they yield reasonably equal results.
}
\examples{
data(durdata)
head(durdata)
risksets <- list(c('job','program'), c('job'))
Fit <- mphcrm(d ~ x1+x2 + C(job,alpha) + ID(id) + D(duration) + S(alpha+1), data=durdata, 
     risksets=risksets, control=mphcrm.control(threads=1,iters=2))
best <- Fit[[1]]
summary(best)
}
\seealso{
A description of the dataset is available in \code{\link{datagen}} and \code{\link{durdata}},
and in the vignette \code{vignette("whatmph")}
}
