% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclusionMatrix.R
\name{exclusionMatrix}
\alias{exclusionMatrix}
\title{Find the number of incompatible markers for each}
\usage{
exclusionMatrix(pm, am, missing, removeMut = TRUE)
}
\arguments{
\item{pm}{A list of singletons, the victims.}

\item{am}{A list of pedigrees. The reference families.}

\item{missing}{A character vector with names of missing persons.}

\item{removeMut}{A logical. If TRUE (default), all mutations models are
stripped.}
}
\value{
An integer matrix with \code{length(pm)} columns and \code{length(am)} rows.
}
\description{
This function computes the number of exclusions, i.e., the number of
incompatible markers, for each pairwise comparison. By default, mutation
models are ignored. The main work is done by \code{\link[forrel:findExclusions]{forrel::findExclusions()}}.
}
\examples{

# Plane crash example
pm = planecrash$pm
am = planecrash$am
missing = planecrash$missing

exclusionMatrix(pm, am, missing)

# Inspect a particular pair: M3 vs V6
forrel::findExclusions(am, id = "M3", candidate = pm$V6)

# Plot one of the incompatible markers
plotPedList(c(am[3], pm[6]), marker = "D7S820", col = list(red = "M3"))


}
