% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{diff1_n}
\alias{diff1_n}
\title{1-Unit Lagged Differences for Numeric Values}
\usage{
diff1_n(x)
}
\arguments{
\item{x}{Numeric vector.}
}
\value{
Numeric vector.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[base]{diff}} for calculating differences between adjacent values 
of a numeric vector. For integer vectors, \code{\link{diff1_i}} should run 
even faster.
}
\examples{
# In general, diff1_n is much faster than diff
x <- rnorm(1000)
all.equal(diff(x), diff1_n(x))
benchmark(diff(x), diff1_n(x), replications = 3000)

# For integer vectors, diff1_i should be even faster
x <- rpois(1000, lambda = 5)
all.equal(diff(x), diff1_i(x))
benchmark(diff(x), diff1_n(x), diff1_i(x), replications = 3000)

}
