% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{range_n}
\alias{range_n}
\title{Range (Actually Minimum and Maximum) of Numeric Values}
\usage{
range_n(x)
}
\arguments{
\item{x}{Numeric vector or matrix.}
}
\value{
Numeric vector.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[base]{range}} for numeric vectors/matrices. For integer objects, 
\code{\link{range_i}} should run even faster.
}
\examples{
# In general, range_n is much faster than range
x <- rnorm(1000)
all.equal(range(x), range_n(x))
benchmark(range(x), range_n(x), replications = 5000)

# For integer vectors, range_i should be even faster
x <- rpois(1000, lambda = 5) 
all.equal(range(x), range_i(x))
benchmark(range(x), range_n(x), range_i(x), replications = 10000)

}
