% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_gamma.R
\name{mle_gamma}
\alias{mle_gamma}
\title{Maximum Likelihood Estimation for X[1], ..., X[n] ~ Gamma(alpha, beta)}
\usage{
mle_gamma(x, alpha = NULL, beta = NULL, estimate_var = FALSE, ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{alpha}{Numeric value specifying known alpha.}

\item{beta}{Numeric value specifying known beta.}

\item{estimate_var}{Logical value for whether to return Hessian-based
variance-covariance matrix.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
Performs maximization via \code{\link[stats]{nlminb}}. alpha and beta 
correspond to the shape and scale (not shape and rate) parameters described 
in \code{\link[stats]{GammaDist}}.
}
\examples{
# Generate 1,000 values from Gamma(0.5, 1) and estimate alpha and beta
set.seed(123)
x <- rgamma(1000, shape = 0.5, scale = 1)
mle_gamma(x)


}
