% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/range-selector.R
\name{dyRangeSelector}
\alias{dyRangeSelector}
\title{dygraph interactive range selection and zooming}
\usage{
dyRangeSelector(dygraph, dateWindow = NULL, height = 40,
  fillColor = " #A7B1C4", strokeColor = "#808FAB", keepMouseZoom = TRUE,
  retainDateWindow = FALSE)
}
\arguments{
\item{dygraph}{Dygraph to add range selector to}

\item{dateWindow}{Initially zoom in on a section of the graph. Is a two
element vector [earliest, latest], where earliest/latest objects
convertible via \code{as.POSIXct}.}

\item{height}{Height, in pixels, of the range selector widget.}

\item{fillColor}{The range selector mini plot fill color. This can be of the
form "#AABBCC" or "rgb(255,100,200)" or "yellow". You can also specify ""
to turn off fill.}

\item{strokeColor}{The range selector mini plot stroke color. This can be of
the form "#AABBCC" or "rgb(255,100,200)" or "yellow". You can also specify
"" to turn off stroke.}

\item{keepMouseZoom}{Keep mouse zoom when adding a range selector}

\item{retainDateWindow}{Whether to retain the user's current date window
  (zoom level) when updating an existing dygraph with new data and/or
  options.}
}
\value{
A dygraph that displays a range selector
}
\description{
Add a range selector to the bottom of the chart that allows users to pan and
zoom to various date ranges.
}
\note{
See the
\href{http://rstudio.github.io/dygraphs/gallery-range-selector.html}{online
documentation} for additional details and examples.

Shiny applications can respond to changes in the \code{dateWindow}
via a special date window shiny input value. For example, if the
output id of a dygraph is `series` then the current date window
can be read from \code{input$series_date_window} as an array of
two date values (from and to).
}
\examples{
library(dygraphs)

dygraph(nhtemp, main = "New Haven Temperatures") \%>\%
  dyRangeSelector()

dygraph(nhtemp, main = "New Haven Temperatures") \%>\%
  dyRangeSelector(dateWindow = c("1920-01-01", "1960-01-01"))

dygraph(nhtemp, main = "New Haven Temperatures") \%>\%
  dyRangeSelector(height = 20, strokeColor = "")
}

