% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynfrail_prep.R
\name{dynfrail_prep}
\alias{dynfrail_prep}
\title{Preparation of the input for \code{dynfrail_fit}}
\usage{
dynfrail_prep(formula, data, distribution = dynfrail_dist(),
  control = dynfrail_control(), ...)
}
\arguments{
\item{formula}{A formula that contains on the left hand side an object of the type \code{Surv}
and on the right hand side a \code{+cluster(id)} statement.}

\item{data}{A data frame in which the formula argument can be evaluated}

\item{distribution}{An object as created by \code{\link{dynfrail_dist}}}

\item{control}{An object as created by \code{\link{dynfrail_control}}}

\item{...}{Other arguments, currently used to warn about deprecated argument names}
}
\value{
A list with what is needed to be used with \code{\link{dynfrail_fit}}
}
\description{
Preparation of the input for \code{dynfrail_fit}
}
\details{
This is an internal function of \code{\link{dynfrail}} thath actually does before going to the inner maximization, except for the starting values.
The input is identical to that from \code{dynfrail}
A scenario where this would be useful would be to make these calculations and then things would be passed on to \code{\link{dynfrail_fit}}.
}
\examples{
arglist1 <- dynfrail_prep(Surv(time, status) ~ rx + sex + cluster(litter),
data = rats)

}
\seealso{
\code{\link{dynfrail}}, \code{\link{dynfrail_fit}}
}
