% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrPlot.R
\name{dynr.ggplot}
\alias{autoplot.dynrCook}
\alias{dynr.ggplot}
\title{The ggplot of the smoothed state estimates and the most likely regimes}
\usage{
dynr.ggplot(res, dynrModel, style = 1, numSubjDemo = 2, idtoPlot = c(),
  names.state, names.observed, names.regime, shape.values, title, ylab,
  is.bw = FALSE, colorPalette = "Set2", fillPalette = "Set2",
  mancolorPalette, manfillPalette, ...)

\method{autoplot}{dynrCook}(object, dynrModel, style = 1, numSubjDemo = 2,
  idtoPlot = c(), names.state, names.observed, names.regime, shape.values,
  title, ylab, is.bw = FALSE, colorPalette = "Set2", fillPalette = "Set2",
  mancolorPalette, manfillPalette, ...)
}
\arguments{
\item{res}{The dynr object returned by dynr.cook().}

\item{dynrModel}{The model object to plot.}

\item{style}{The style of the plot. If style is 1 (default), user-selected smoothed state variables are plotted. If style is 2, user-selected observed-versus-predicted values are plotted.}

\item{numSubjDemo}{The number of subjects to be randomly selected for plotting.}

\item{idtoPlot}{Values of the ID variable to plot}

\item{names.state}{(optional) The names of the states to be plotted, which should be a subset of the state.names slot of the measurement slot of dynrModel.}

\item{names.observed}{(optional) The names of the observed variables to be plotted, which should be a subset of the obs.names slot of the measurement slot of dynrModel.}

\item{names.regime}{(optional) The names of the regimes to be plotted, which can be missing.}

\item{shape.values}{(optional) A vector of values that correspond to the shapes of the points, which can be missing. See the R documentation on pch for details on possible shapes.}

\item{title}{(optional) A title of the plot.}

\item{ylab}{(optional) The label of the y axis.}

\item{is.bw}{Is plot in black and white? The default is FALSE.}

\item{colorPalette}{A palette function for lines and dots that when called with a single integer argument (the number of levels in the scale) returns the values that they should take.}

\item{fillPalette}{A palette function for blocks that when called with a single integer argument (the number of levels in the scale) returns the values that they should take.}

\item{mancolorPalette}{(optional) A color palette for manually scaling the colors of lines and plots.}

\item{manfillPalette}{(optional) A color palette for manually scaling the colors of filled blocks.}

\item{...}{A list of element name, element pairings that modify the existing ggplot2::ggplot ggplot2::theme. Consult the ggplot2::theme() function in the R package ggplot2::ggplot.}

\item{object}{The same as res. The dynr object returned by dynr.cook().}
}
\description{
The ggplot of the smoothed state estimates and the most likely regimes
}
\details{
The two functions \code{dynr.ggplot} and \code{autoplot} as identical aliases of one another.  The \code{autoplot} function is an S3 method from ggplot2 that allows many objects to be plotted in that package.
}

