% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.matrixDynamics}
\alias{prep.matrixDynamics}
\title{Recipe function for creating Linear Dynamcis using matrices}
\usage{
prep.matrixDynamics(params.dyn = NULL, values.dyn, params.exo = NULL,
  values.exo = NULL, params.int = NULL, values.int = NULL, covariates,
  isContinuousTime)
}
\arguments{
\item{params.dyn}{the matrix of parameter names for the transition matrix in the 
specified linear dynamic model}

\item{values.dyn}{the matrix of starting/fixed values for the transition matrix in the 
specified linear dynamic model}

\item{params.exo}{the matrix of parameter names for the regression slopes of covariates on the latent variables (see details)}

\item{values.exo}{matrix of starting/fixed values for the regression slopes of covariates on the latent variables (see details)}

\item{params.int}{vector of names for intercept parameters in the dynamic model specified as a matrix or list of matrices.}

\item{values.int}{vector of intercept values in the dynamic model specified as matrix or list of matrices. Contains starting/fixed values of the intercepts.}

\item{covariates}{the names or the index numbers of the covariates used in the dynamic model}

\item{isContinuousTime}{logical. When TRUE, use a continuous time model.  When FALSE use a discrete time model.}
}
\description{
Recipe function for creating Linear Dynamcis using matrices
}
\details{
The right-hand-side of the dynamic model consists of a vector of latent variables for the next time point in the discrete time case,
and the vector of derivatives for the latent variables at the current time point in the continuous time case.
}

