% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc.R
\name{matchCellMarker2}
\alias{matchCellMarker2}
\title{Match Markers with cellMarker2 Dataset}
\usage{
matchCellMarker2(marker, n, spc)
}
\arguments{
\item{marker}{A data frame of markers obtained from the \code{FindAllMarkers}
function, expected to contain columns such as \code{avg_log2FC}, \code{p_val_adj},
and \code{gene}.}

\item{n}{An integer specifying the top number of genes to match from the
input markers.}

\item{spc}{A character string specifying the species, which can be either
'Human' or 'Mouse'.}
}
\value{
A data frame containing matched markers from the \code{cellMarker2}
dataset, with additional columns indicating the number of matches and
ordered symbols.
}
\description{
This function matches markers from the \code{FindAllMarkers} output with the
\code{cellMarker2} dataset, filtering by species and selecting the top genes based
on their average log2 fold change and adjusted p-values.
}
\examples{
# Example usage:
# Match the top 50 markers from the pbmc.markers dataset with the Human
# species in the cellMarker2 dataset.
library(easybio)
data(pbmc.markers)
matched_markers <- matchCellMarker2(pbmc.markers, n = 50, spc = "Human")
print(matched_markers)
}
