% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_km}
\alias{plot_km}
\title{Plot Kaplan-Meier Data}
\usage{
plot_km(
  fit,
  risktable = TRUE,
  risktable_symbols = TRUE,
  median_line = TRUE,
  legend_position = "top",
  plot_theme = theme_easysurv(),
  risktable_theme = theme_risktable_easysurv()
)
}
\arguments{
\item{fit}{A \link[survival:survfit]{survival::survfit} object representing the
survival data.}

\item{risktable}{Logical value indicating whether to include a risk table
below the plot. Default is \code{TRUE}.}

\item{risktable_symbols}{Logical value indicating whether to include symbols
instead of text to label risk table strata. Default is \code{TRUE}.}

\item{median_line}{Logical value indicating whether to include a line
representing the median survival time. Default is \code{TRUE}.}

\item{legend_position}{Position of the legend in the plot. Default is
"top".}

\item{plot_theme}{ggplot2 theme for the plot. Default is
\code{theme_easysurv()}.}

\item{risktable_theme}{ggplot2 theme for the risk table. Default is
\code{theme_risktable_easysurv()}.}
}
\value{
A ggplot object representing the Kaplan-Meier survival curve plot.
}
\description{
Generates a Kaplan-Meier survival curve plot using
\code{\link[ggsurvfit:ggsurvfit]{ggsurvfit::ggsurvfit()}} with customizable options.
This function provides sensible defaults while allowing for customization.
}
\examples{
library(ggsurvfit)
fit <- survfit2(Surv(time, status) ~ surg, data = df_colon)
plot_km(fit, risktable_symbols = FALSE)
}
