% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemUsageConstraint.R
\name{itemUsageConstraint}
\alias{itemUsageConstraint}
\title{Create item usage constraints.}
\usage{
itemUsageConstraint(
  nForms,
  nItems,
  operator = c("<=", "=", ">="),
  targetValue = 1
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool.}

\item{operator}{a character indicating which operator should be used in the
constraints, with three possible values: \code{"<="}, \code{"="},
or \code{">="}. See details for more information.}

\item{targetValue}{The value to be used in the constraints}
}
\value{
A sparse matrix.
}
\description{
Creates constraints related to item usage. That is, the number of times an item
is selected is constrained to be either (a) smaller or equal than
(\code{operator = "<="}), (b) equal to (\code{operator = "="}),
or (c) greater or equal than (\code{operator = ">="}) the chosen \code{value}.
}
\details{
When \code{operator = "<="} and \code{value = 1} (the default), each item can
be selected maximally once, which corresponds with assuring that there is no
item overlap between the forms. When \code{operator = "="} and \code{value = 1},
each item is used exactly once, which corresponds to no item-overlap and
complete item pool depletion.
}
\examples{
## create no-item overlap constraints with item pool depletion
##  for 2 test forms with an item pool of 20 items
itemUsageConstraint(2, 20, operator = "=", targetValue = 1)

}
