% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractData.R
\name{extractData}
\alias{extractData}
\title{Extract Data}
\usage{
extractData(
  GADSdat,
  convertMiss = TRUE,
  convertLabels = "character",
  dropPartialLabels = TRUE,
  convertVariables = NULL
)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{convertMiss}{Should values coded as missing values be recoded to \code{NA}?}

\item{convertLabels}{If \code{"numeric"}, values remain as numerics. If \code{"factor"} or \code{"character"}, values are recoded to their labels. Corresponding variable type is applied.}

\item{dropPartialLabels}{Should value labels for partially labeled variables be dropped? If \code{TRUE}, the partial labels will be dropped. If \code{FALSE}, the variable will be converted to the class specified in \code{convertLabels}.}

\item{convertVariables}{Character vector of variables names, which labels should be applied to. If not specified (default), value labels are applied to all variables for which labels are available. Variable names not in the actual GADS are silently dropped.}
}
\value{
Returns a data frame.
}
\description{
Extract \code{data.frame} from a \code{GADSdat} object for analyses in \code{R}. For extracting meta data see \code{\link{extractMeta}}..
}
\details{
A \code{GADSdat} object includes actual data (\code{GADSdat$dat}) and the corresponding meta data information
(\code{GADSdat$labels}). \code{extractData} extracts the data and applies relevant meta data (missing conversion, value labels),
so the data can be used for analyses in \code{R}.

If \code{factor} are extracted via \code{convertLabels == "factor"}, an attempt is made to preserve the underlying integers.
If this is not possible, a warning is issued.
As \code{SPSS} has almost no limitations regarding the underlying values of labeled
integers and \code{R}'s \code{factor} format is very strict (no \code{0}, only integers increasing by \code{+ 1}), this procedure can lead to
frequent problems.
}
\examples{
# Extract Data for Analysis
dat <- extractData(pisa)

# convert labeled variables to factors
dat <- extractData(pisa, convertLabels = "factor")

# convert only some variables to factor
dat <- extractData(pisa, convertLabels = "factor", convertVariables = c("schtype", "ganztag"))

}
