% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changeValLabels.R
\name{changeValLabels}
\alias{changeValLabels}
\title{Change value labels.}
\usage{
changeValLabels(GADSdat, varName, value, valLabel)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Character string of a variable name.}

\item{value}{Numeric values.}

\item{valLabel}{Character string of the new value labels.}
}
\value{
Returns the \code{GADSdat} object with changed meta data.
}
\description{
Change or add value labels of a variable as part of a \code{GADSdat} or \code{all_GADSdat} object.
}
\details{
Applied to a \code{GADSdat} or \code{all_GADSdat} object, this function is a wrapper of \code{\link{getChangeMeta}} and
\code{\link{applyChangeMeta}}.
}
\examples{
# Change existing value labels
pisa2 <- changeValLabels(pisa, varName = "repeated",
                        value = c(1, 2),
                        valLabel = c("no grade repetition", "grade repitition"))

# Add value label to unlabeled value
mtcars_g <- import_DF(mtcars)
mtcars_g2 <- changeValLabels(mtcars_g, varName = "cyl",
                             value = c(4, 6, 8),
                             valLabel = c("four", "six", "eight"))

}
