% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitGADS.R
\name{splitGADS}
\alias{splitGADS}
\title{Split \code{GADSdat} into hierarchy levels.}
\usage{
splitGADS(GADSdat, nameList)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{nameList}{A list of character vectors. The names in the list correspond the the hierarchy levels.}
}
\value{
Returns an \code{all_GADSdat} object, which consists of list with a list of all data frames \code{"datList"} and
a single data frame containing all meta data information \code{"allLabels"}. For more details see also \code{\link{mergeLabels}}.
}
\description{
Split a \code{GADSdat} into multiple, specified hierarchical levels.
}
\details{
The function takes a \code{GADSdat} object and splits it into its desired hierarchical levels (a \code{all_GADSdat} object).
Hierarchy level of a variable is also accessible in the meta data via the column \code{data_table}. If not all variable names
are included in the \code{nameList}, the missing variables will be dropped.
}
\examples{
# see createGADS vignette

}
