% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_analyse.R
\name{ebv_analyse}
\alias{ebv_analyse}
\title{Get a simple explorative analysis of an EBV netCDF datacube}
\usage{
ebv_analyse(
  filepath,
  datacubepath,
  entity = NULL,
  timestep = 1,
  subset = NULL,
  touches = TRUE,
  epsg = 4326,
  numerical = TRUE,
  na_rm = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{filepath}{Character. Path to the netCDF file.}

\item{datacubepath}{Character. Path to the datacube (use
\code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}).}

\item{entity}{Character or Integer. Default is NULL. If the structure is 3D,
the entity argument is set to NULL. Else, a character string or single
integer value must indicate the entity of the 4D structure of the EBV
netCDFs.}

\item{timestep}{Integer. Choose one or several timesteps (vector).}

\item{subset}{Optional if you want measurements on a smaller subset. Possible
via the path to a shapefile (character) or the indication of a bounding box
(vector of four numeric values) defining the subset. Else the whole area is
analysed.}

\item{touches}{Logical. Optional. Default: TRUE. Only relevant if the subset is
indicated by a shapefile. See \code{\link[=ebv_read_shp]{ebv_read_shp()}}.}

\item{epsg}{Numeric. Optional. Only relevant if the subset is indicated by a
bounding box and the coordinate reference system differs from WGS84. See
\code{\link[=ebv_read_bb]{ebv_read_bb()}}.}

\item{numerical}{Logical. Default: TRUE. Change to FALSE if the data covered
by the netCDF contains categorical data.}

\item{na_rm}{Logical. Default: TRUE. NA values are removed in the analysis.
Change to FALSE to include NAs.}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Returns a named list containing the measurements.
}
\description{
Get basic measurements of the data, including min, max, mean,
sd, n, #NAs, q25, q50, q75 (no mean for categorical data).
}
\examples{
#set path to EBV netCDF
file <- system.file(file.path("extdata","martins_comcom_id1_20220208_v1.nc"), package="ebvcube")
#get all datacubepaths of EBV netCDF
datacubes <- ebv_datacubepaths(file, verbose=FALSE)
#set path to shp file
shp_path <- system.file(file.path("extdata","subset_germany.shp"), package="ebvcube")

\donttest{
#get measurements for full extent and all timesteps
data_global <- ebv_analyse(filepath = file, datacubepath = datacubes[1,1],
                           entity = 1, timestep = 1:3)

#get measurements for germany only (using bounding box) and one timestep
data_bb_1900 <- ebv_analyse(filepath = file, datacubepath = datacubes[1,1],
                            entity = 1, timestep = 2, subset = c(5,15,47,55))

#get measurements for germany only (using shp) and one timestep
data_shp_1900 <- ebv_analyse(filepath = file, datacubepath = datacubes[1,1],
                             entity = 1, timestep = 3, subset = shp_path)
}
}
\seealso{
\code{\link[=ebv_read_bb]{ebv_read_bb()}} and \code{\link[=ebv_read_shp]{ebv_read_shp()}}
for the usage of subsets.
}
