% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_properties.R
\name{ebv_properties}
\alias{ebv_properties}
\title{Read properties of EBV netCDF}
\usage{
ebv_properties(filepath, datacubepath = NULL, verbose = TRUE)
}
\arguments{
\item{filepath}{Character. Path to the netCDF file.}

\item{datacubepath}{Character. Optional. Path to the datacube (use
\code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}).}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
S4 class containing information about file or file and datacube
depending on input.
}
\description{
Structured access to all attributes of the netCDF file.
}
\examples{
#set path to EBV netCDF
file <- system.file(file.path("extdata","martins_comcom_subset.nc"), package="ebvcube")
#get all datacubepaths of EBV netCDF
datacubes <- ebv_datacubepaths(file, verbose=FALSE)

#get properties only for the file
prop_file <- ebv_properties(file)
#get properties for the file and a specific datacube
prop_dc <- ebv_properties(file, datacubes[1,1])
}
