% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_add_data.R
\name{ebv_add_data}
\alias{ebv_add_data}
\title{Add data to your EBV netCDF}
\usage{
ebv_add_data(
  filepath_nc,
  datacubepath = NULL,
  entity = NULL,
  timestep = 1,
  data,
  band = 1,
  scenario = NULL,
  metric = NULL,
  ignore_RAM = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filepath_nc}{Character. Path to the self-created netCDF file.}

\item{datacubepath}{Character. Optional. Default: NULL. Path to the datacube
(use \code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}). Alternatively, you can use the
scenario and metric argument to define which cube you want to access.}

\item{entity}{Character or Integer. Default is NULL. If the structure is 3D,
the entity argument is set to NULL. Else, a character string or single
integer value must indicate the entity of the 4D structure of the EBV
netCDFs. The character string can be obtained using
\code{\link[=ebv_properties]{ebv_properties()}}. Choose the entity you are interested in from
the slot general and the list item entity_names.}

\item{timestep}{Integer or character. Default: 1. Define to which timestep or
timesteps the data should be added. If several timesteps are given they
have to be in a continuous and in order. Meaning c(4,5,6) is right but
c(2,5,6) is wrong. Alternatively you can provide a date or list of dates in
ISO format, such as '2015-01-01' (also in order).}

\item{data}{Character or matrix or array. If character: Path to the GeoTiff
file containing the data. Ending needs to be *.tif. If matrix or array:
in-memory object holding the data.}

\item{band}{Integer. Default: 1. Define which band(s) to read from GeoTiff.
Can be several. Don't have to be in order as the timesteps definition
requires.}

\item{scenario}{Character or integer. Optional. Default: NULL. Define the
scenario you want to access. If the EBV netCDF has no scenarios, leave the
default value (NULL). You can use an integer value defining the scenario or
give the name of the scenario as a character string. To check the available
scenarios and their name or number (integer), use
\code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}.}

\item{metric}{Character or integer. Optional. Define the metric you want to
access. You can use an integer value defining the metric or give the name
of the scenario as a character string. To check the available metrics and
their name or number (integer), use \code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}.}

\item{ignore_RAM}{Logical. Default: FALSE. Checks if there is enough space in
your memory to read the data. Can be switched off (set to TRUE). Ignore
this argument when you give an array or a matrix for 'data' (it will do
nothing).}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Adds data to the EBV netCDF. Check your results using
\code{\link[=ebv_read]{ebv_read()}} and/or \code{\link[=ebv_analyse]{ebv_analyse()}} and/or
\code{\link[=ebv_map]{ebv_map()}} and/or \code{\link[=ebv_trend]{ebv_trend()}}.
}
\description{
Add data to your EBV netCDF from GeoTiffs or in-memory arrays.
First, create a new EBV netCDF using \code{\link[=ebv_create]{ebv_create()}}.
}
\note{
If the data exceeds your memory the RAM check will throw an error. No
block-processing or other method implemented so far. Move to a machine with
more capacities if needed.
}
\examples{
#set path to EBV netCDF
file <- system.file(file.path("extdata","test.nc"), package="ebvcube")
#get all datacubepaths of EBV netCDF
datacubepaths <- ebv_datacubepaths(file, verbose=FALSE)
#set path to GeoTiff with data
tif <- system.file(file.path("extdata","entity1.tif"), package="ebvcube")

# add data to the timestep 1, 2 and 3 using the first three bands of the GeoTiff
\dontrun{
#use datacubepath argument and define timestep by integer
ebv_add_data(filepath_nc = file, datacubepath = datacubepaths[1,1],
             entity = 1, timestep = 1:3, data = tif, band = 1:3)
#use metric argument and define timestep by ISO-format
ebv_add_data(filepath_nc = file, entity = 1,
             timestep = paste0(as.character(seq(1900,1920,10)), '-01-01'),
             metric = 1, data = tif, band = 1:3, verbose = FALSE)
}
}
