% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-ivol-ogf-star-method.R
\name{ecld.ivol_ogf_star}
\alias{ecld.ivol_ogf_star}
\title{Calculate implied volatility using star OGF and small sigma formula}
\usage{
ecld.ivol_ogf_star(object, ki, epsilon = 0, otype = "c",
  order.local = Inf, order.global = Inf, ignore.mu = FALSE)
}
\arguments{
\item{object}{an object of ecld class}

\item{ki}{a numeric vector of log-strike}

\item{epsilon}{numeric, small asymptotic premium added to local regime}

\item{otype}{option type}

\item{order.local}{numeric, order of the hypergeometric series to be computed
for local regime. Default is \code{Inf}, use the incomplete gamma.
When it is \code{NaN}, \code{L*} value is suppressed.}

\item{order.global}{numeric, order of the hypergeometric series to be computed
for global regime. Default is \code{Inf}, use the incomplete gamma.
If \code{NaN}, then revert to OGF.}

\item{ignore.mu}{logical, ignore \code{exp(mu)} on both sides, default is \code{FALSE}.}
}
\value{
The state price of option in star OGF terms.
        For \code{ecld.ivol_ogf_star}, it is \eqn{\sigma_1}.
}
\description{
Calculate implied volatility using star OGF and small sigma formula.
SGED is not supported yet.
}
\examples{
ld <- ecld(sigma=0.001)
ecld.ivol_ogf_star(ld, 0)
}
\author{
Stephen H-T. Lihn
}
\keyword{ogf}

