% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_estimation.R
\name{get_estimation_gini}
\alias{get_estimation_gini}
\title{This function allows you to estimate the Gini coefficient}
\usage{
get_estimation_gini(
  data = ech::toy_ech_2018,
  variable = NULL,
  by = NULL,
  level = NULL,
  ids = NULL,
  numero = "numero",
  estrato = NULL,
  pesoano = "pesoano",
  bootstrap = FALSE,
  r = NULL
)
}
\arguments{
\item{data}{ech data frame}

\item{variable}{Variable name of income without rental value per capita deflated}

\item{by}{data frame column}

\item{level}{is household ("h") or individual ("i").}

\item{ids}{Variable name of cluster}

\item{numero}{Variable name of household id}

\item{estrato}{Variable name of strata}

\item{pesoano}{Variable name of weights}

\item{bootstrap}{Logical value}

\item{r}{A number of replicas}
}
\value{
table
}
\description{
This function allows you to estimate the Gini coefficient
}
\details{
Disclaimer: This script is not an official INE product.
Aviso: El script no es un producto oficial de INE.
}
\examples{
\donttest{
toy_ech_2018 <- income_constant_prices(data = ech::toy_ech_2018, index = "IPC", level = "R",
                                       base_month = "01", base_year = "2005")
get_estimation_gini(data = toy_ech_2018, variable = "y_wrv_pc_d_r", level = "i")
}
}
\seealso{
Other estimation: 
\code{\link{get_estimation_gpg}()},
\code{\link{get_estimation_mean}()},
\code{\link{get_estimation_median}()},
\code{\link{get_estimation_qsr}()},
\code{\link{get_estimation_ratio}()},
\code{\link{get_estimation_total}()},
\code{\link{set_design}()}
}
\concept{estimation}
