% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{vd_dem_vdm_ss}
\alias{vd_dem_vdm_ss}
\title{Demand Prediction (Volumetric demand, accounting for set-size variation, EV1 errors)}
\usage{
vd_dem_vdm_ss(vd, est, epsilon_not = NULL, cores = NULL)
}
\arguments{
\item{vd}{data}

\item{est}{ec-model draws}

\item{epsilon_not}{(optional) error realizations}

\item{cores}{(optional) cores}
}
\value{
Draws of expected demand
}
\description{
Generating demand predictions for volumetric demand model with set-size adjustment.
Reminder: there is no closed-form solution for demand, thus we need to integrate not only over the posterior distribution of parameters and the error distribution.
The function outputs a tibble containing id, task, alt, p, attributes, draws from the posterior of demand.
Eerror realizations can be pre-supplied to the \code{epsilon_not}. This helps create smooth demand curves or conduct optimization.
}
\examples{
data(icecream)
#run MCMC sampler (use way more than 10 draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<10) \%>\% vd_est_vdm_ss(R=10, keep=1, cores=2)
#Generate demand predictions
icecream_predicted_demand=
 icecream \%>\% dplyr::filter(id<10) \%>\%   
   vd_dem_vdm_ss(icecream_est, cores=2)
#column .demdraws contains draws from posterior of predicted demand

}
\seealso{
\code{\link[=prep_newprediction]{prep_newprediction()}} to match \code{vd}'s factor levels,
\code{\link[=ec_gen_err_ev1]{ec_gen_err_ev1()}} for pre-generating error realizations and
\code{\link[=vd_est_vdm_ss]{vd_est_vdm_ss()}} for estimating the corresponding model
}
