% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace_coverage.R
\name{trace_coverage}
\alias{trace_coverage}
\alias{trace_coverage.eventlog}
\alias{trace_coverage.grouped_eventlog}
\title{Metric: Trace coverage}
\usage{
trace_coverage(eventlog, level, append, ...)

\method{trace_coverage}{eventlog}(eventlog, level = c("log", "trace", "case"),
  append = F, append_column = NULL, sort = TRUE, ...)

\method{trace_coverage}{grouped_eventlog}(eventlog, level = c("log", "trace",
  "case"), append = F, append_column = NULL, sort = TRUE, ...)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.
\code{eventlog}.}

\item{level}{Level of granularity for the analysis: log,  case, activity, resource or resource-activity.
For more information, see \code{vignette("metrics", "edeaR")}}

\item{append}{Logical, indicating whether to append results to original event log. Ignored when level is log or trace.}

\item{...}{Deprecated arguments}

\item{append_column}{Which of the output columns to append to log, if append = T. Default column depends on chosen level.}

\item{sort}{Sort by decreasing throughput time. Defaults to true. Only relevant for case level.}
}
\description{
Analyses the structuredness of an event log by use of trace frequencies. Applicable at logn case and trace level
}
\details{
\itemize{
\item Trace: The absolute and relative frequency of each trace is returned

\item Case: for each case, the coverage of the corresponding trace is returned

\item Log: Summary statistics of the coverage of traces is returned.
}
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Trace coverage metric for eventlog

\item \code{grouped_eventlog}: Trace coverage metric for grouped eventlog
}}

\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
