% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/download_master.R
\name{DownloadMaster}
\alias{DownloadMaster}
\title{Retrieve the quarterly Master Index files from SEC.org site.}
\usage{
DownloadMaster(year.array)
}
\arguments{
\item{year.array}{year in integer or integer array containing years for which Master
Index are to be downloaded.}
}
\value{
Function retrieve the quarterly Master Index files
from \url{ftp://ftp.sec.gov/edgar} site and returns download status dataframe.
}
\description{
\code{DownloadMaster} retrieve the quarterly Master Index files.
}
\details{
DownloadMaster function takes years as a parameter to download quarterly Master Index
files and stores into Rda yearly format. It ask the user to locate the
working directory. New directory 'Master Files' will be created and all the Rda
master files get stored into it. Please note, for all other functions in this
package needs to locate the same working directory to access these Rda index files.
}
\examples{
\dontrun{

report <- DownloadMaster(1995)
## Download quarterly Master Index files for the year 1990 and stores into yearly
## 1995master.Rda file. It returns the download report in dataframe format.

report <- DownloadMaster(c(1994, 1995, 2006))
## Download quarterly Master Index files for the years 1995, 1996, 1998 and stores into
## different {year}master.Rda files. It returns the download report in dataframe format.
}
}

