% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchFilings.R
\name{searchFilings}
\alias{searchFilings}
\title{Search EDGAR filings for specific words}
\usage{
searchFilings(cik.no, form.type, filing.year, word.list)
}
\arguments{
\item{cik.no}{vector of CIK number of firms in integer format. Suppress leading 
zeroes from CIKs. Keep cik.no = 'ALL' if needs to download for all CIK's.}

\item{form.type}{character vector containing form type to be downloaded. 
form.type = 'ALL' if need to download all forms.}

\item{filing.year}{vector of four digit numeric year}

\item{word.list}{vector of words to search in the filing}
}
\value{
Function returns dataframe containing filing information, size of the 
filing, and the number of word hits based on the input phrases. Following are 
the definitions of some important variables:  
 
file.size = Total number of words in the filing. It does not consider stop words.
nword.hits = Number of total hits found in the filing based on the search word list.
}
\description{
\code{searchFilings} Search EDGAR filings for specific words
}
\details{
searchFilings function takes search word vector, CIK(s), form type(s), and 
year(s) as input parameters. The function first imports available 
downloaded filings in local woking directory 
'Edgar filings' created by \link[edgar]{getFilings} function; otherwise, 
it downloads the filings which is not already been downloaded.
It then reads the filings, cleans the filings, and 
search for the input words. The function returns a dataframe
with filing information, size of the filing, and the number of word hits.
}
\examples{
\dontrun{

word.list = c('derivative','hedging','currency forwards','currency futures')
output <- searchFilings(cik.no = c('1000180', '38079'), 
                     form.type = c("10-K", "10-K405","10KSB", "10KSB40"), 
                     filing.year = c(2005, 2006), word.list) 
}
}
