% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trts.R
\name{set_trts}
\alias{set_trts}
\title{Set the treatment variables}
\usage{
set_trts(
  .edibble,
  ...,
  .name_repair = c("check_unique", "unique", "universal", "minimal"),
  .record = TRUE
)
}
\arguments{
\item{.edibble}{An edibble design (\code{edbl_design}), an edibble data frame (\code{edbl_table}) or an
object that contains the edibble data frame in the attribute
\code{design}.}

\item{...}{Either a name-value pair or a series of the names.}

\item{.name_repair}{Same as the argument in \code{tibble::tibble()}.}

\item{.record}{A logical value. This indicates whether to record this
code step. The default is TRUE. It should remain TRUE unless this
function is used as a wrapper in other code.}
}
\value{
An edibble design.
}
\description{
This function add a special class, called \code{edbl_trt}, of edibble variables.
}
\section{Definition of \emph{treatment}}{

The word \emph{treatment} is sometimes used to refer to one of these variables.
When there are more than one treatment variables then this unfortunately
confuses whether treatment refers to the variable or the combination of
all treatment variables.

Treatment is the whole description of what is applied in an experiment.
}

\examples{

design() \%>\%
  set_trts(pesticide = c("A", "B", "C"),
           dosage = c(0, 10, 20, 30, 40))

}
\seealso{
Other user-facing functions: 
\code{\link{allot}},
\code{\link{design}()},
\code{\link{expect_rcrds}()},
\code{\link{export_design}()},
\code{\link{serve_table}()},
\code{\link{set_rcrds}()},
\code{\link{set_units}()}
}
\concept{user-facing functions}
