% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcrds.R
\name{set_rcrds}
\alias{set_rcrds}
\alias{set_rcrds_of}
\title{Set records for given unit}
\usage{
set_rcrds(
  .edibble,
  ...,
  .name_repair = c("check_unique", "unique", "universal", "minimal"),
  .record = TRUE
)

set_rcrds_of(.edibble, ...)
}
\arguments{
\item{.edibble}{An edibble design (\code{edbl_design}), an edibble data frame (\code{edbl_table}) or an
object that contains the edibble data frame in the attribute
\code{design}.}

\item{...}{Name-value pair. The value should correspond to a single name of the
unit defined in \code{set_units}. The name should be the name of the record variable.}

\item{.name_repair}{Same as the argument in \code{tibble::tibble()}.}

\item{.record}{A logical value. This indicates whether to record this
code step. The default is TRUE. It should remain TRUE unless this
function is used as a wrapper in other code.}
}
\value{
An edibble design.
}
\description{
This function creates new nodes to edibble graph with the name
corresponding to either the intended response that will be measured or
a variable to be recorded.
}
\examples{
takeout(menu_crd(t = 4, n = 10)) \%>\%
  set_rcrds(y = unit)

takeout(menu_crd(t = 4, n = 10)) \%>\%
  set_rcrds_of(unit = "y")
}
\seealso{
Other user-facing functions: 
\code{\link{allot}},
\code{\link{design}()},
\code{\link{expect_rcrds}()},
\code{\link{export_design}()},
\code{\link{serve_table}()},
\code{\link{set_trts}()},
\code{\link{set_units}()}
}
\concept{user-facing functions}
