% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textInput3.R
\name{label3}
\alias{label3}
\title{Create a side-by-side label}
\usage{
label3(label, width = 100, bg = NULL, ...)
}
\arguments{
\item{label}{A text to display}

\item{width}{The width of the input in pixel}

\item{bg}{The color of text}

\item{...}{arguments to be passed to label}
}
\description{
Create a side-by-side label
}
\examples{
library(shiny)
# Only run examples in interactive R sessions
if (interactive()) {
  ui <- fluidPage(
         label3("Welcome"),
         checkboxInput3("somevalue", "Some value", FALSE),
         verbatimTextOutput("value")
  )
  server <- function(input, output) {
        output$value <- renderText({ input$somevalue })
  }
  shinyApp(ui, server)
}
}
