
#' Fraction Subtraction and Addition Assessment Item Responses
#'
#' @details
#' The subjects answered the following assessment items:
#'
#' - `Item01`: \eqn{\frac{5}{3}-\frac{3}{4}}{5/3 - 3/4}
#' - `Item02`: \eqn{\frac{3}{4}-\frac{3}{8}}{3/4 - 3/8}
#' - `Item03`: \eqn{\frac{5}{6}-\frac{1}{9}}{5/6 - 1/9}
#' - `Item04`: \eqn{3\frac{1}{2}-2\frac{3}{2}}{3*1/2 - 2*3/2}
#' - `Item05`: \eqn{4\frac{3}{5}-3\frac{4}{10}}{4*3/5 - 3*4/10}
#' - `Item06`: \eqn{\frac{6}{7}-\frac{4}{7}}{6/7 - 4/7}
#' - `Item07`: \eqn{3-2\frac{1}{5}}{3 - 2*1/5}
#' - `Item08`: \eqn{\frac{2}{3}-\frac{2}{3}}{2/3 - 2/3}
#' - `Item09`: \eqn{3\frac{7}{8}-2}{3*7/8 - 2}
#' - `Item10`: \eqn{4\frac{4}{12}-2\frac{7}{12}}{4*4/12 - 2*7/12}
#' - `Item11`: \eqn{4\frac{1}{3}-2\frac{4}{3}}{4*1/3 - 2*4/3}
#' - `Item12`: \eqn{\frac{11}{8}-\frac{1}{8}}{11/8 - 1/8}
#' - `Item13`: \eqn{3\frac{3}{8}-2\frac{5}{6}}{3*3/8 - 2*5/6}
#' - `Item14`: \eqn{3\frac{4}{5}-3\frac{2}{5}}{3*4/5 - 3*2/5}
#' - `Item15`: \eqn{2-\frac{1}{3}}{2 - 1/3}
#' - `Item16`: \eqn{4\frac{5}{7}-1\frac{4}{7}}{4*5/7 - 1*4/7}
#' - `Item17`: \eqn{7\frac{3}{5}-2\frac{4}{5}}{7*3/5 - 2*4/5}
#' - `Item18`: \eqn{4\frac{1}{10}-2\frac{8}{10}}{4*1/10 - 2*8/10}
#' - `Item19`: \eqn{4-1\frac{4}{3}}{4 - 1*4/3}
#' - `Item20`: \eqn{4\frac{1}{3}-1\frac{5}{3}}{4*1/3 - 1*5/3}
#'
#' @template papers-fractions
"items_fractions"

#' Fraction Subtraction and Addition Assessment Expert-Derived Q Matrix
#'
#' @details
#' Each entry in the matrix is either `1`, if the Item uses the Trait, or `0`, if
#' the Item does not use the Trait. The traits identified by this `matrix` are:
#'
#' - `Trait1`: Convert a whole number to a fraction,
#' - `Trait2`: Separate a whole number from fraction,
#' - `Trait3`: Simplify before subtraction,
#' - `Trait4`: Find a common denominator,
#' - `Trait5`: Borrow from the whole number part,
#' - `Trait6`: Column borrow to subtract the second numerator from the first,
#' - `Trait7`: Subtract numerators,
#' - `Trait8`: Reduce answers to simplest form.
#'
#' The subjects answered the following assessment items:
#'
#' - `Item01`: \eqn{\frac{5}{3}-\frac{3}{4}}{5/3 - 3/4}
#' - `Item02`: \eqn{\frac{3}{4}-\frac{3}{8}}{3/4 - 3/8}
#' - `Item03`: \eqn{\frac{5}{6}-\frac{1}{9}}{5/6 - 1/9}
#' - `Item04`: \eqn{3\frac{1}{2}-2\frac{3}{2}}{3*1/2 - 2*3/2}
#' - `Item05`: \eqn{4\frac{3}{5}-3\frac{4}{10}}{4*3/5 - 3*4/10}
#' - `Item06`: \eqn{\frac{6}{7}-\frac{4}{7}}{6/7 - 4/7}
#' - `Item07`: \eqn{3-2\frac{1}{5}}{3 - 2*1/5}
#' - `Item08`: \eqn{\frac{2}{3}-\frac{2}{3}}{2/3 - 2/3}
#' - `Item09`: \eqn{3\frac{7}{8}-2}{3*7/8 - 2}
#' - `Item10`: \eqn{4\frac{4}{12}-2\frac{7}{12}}{4*4/12 - 2*7/12}
#' - `Item11`: \eqn{4\frac{1}{3}-2\frac{4}{3}}{4*1/3 - 2*4/3}
#' - `Item12`: \eqn{\frac{11}{8}-\frac{1}{8}}{11/8 - 1/8}
#' - `Item13`: \eqn{3\frac{3}{8}-2\frac{5}{6}}{3*3/8 - 2*5/6}
#' - `Item14`: \eqn{3\frac{4}{5}-3\frac{2}{5}}{3*4/5 - 3*2/5}
#' - `Item15`: \eqn{2-\frac{1}{3}}{2 - 1/3}
#' - `Item16`: \eqn{4\frac{5}{7}-1\frac{4}{7}}{4*5/7 - 1*4/7}
#' - `Item17`: \eqn{7\frac{3}{5}-2\frac{4}{5}}{7*3/5 - 2*4/5}
#' - `Item18`: \eqn{4\frac{1}{10}-2\frac{8}{10}}{4*1/10 - 2*8/10}
#' - `Item19`: \eqn{4-1\frac{4}{3}}{4 - 1*4/3}
#' - `Item20`: \eqn{4\frac{1}{3}-1\frac{5}{3}}{4*1/3 - 1*5/3}
#'
#' @template papers-fractions
"qmatrix_fractions"
