% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_chisq.R
\name{chisq_to_phi}
\alias{chisq_to_phi}
\alias{chisq_to_cohens_w}
\alias{chisq_to_cramers_v}
\alias{phi_to_chisq}
\title{Conversion Chi-Squared to Phi or Cramer's V}
\usage{
chisq_to_phi(chisq, n, nrow, ncol, ci = 0.95, adjust = FALSE, ...)

chisq_to_cohens_w(chisq, n, nrow, ncol, ci = 0.95, adjust = FALSE, ...)

chisq_to_cramers_v(chisq, n, nrow, ncol, ci = 0.95, adjust = FALSE, ...)

phi_to_chisq(phi, n, ...)
}
\arguments{
\item{chisq}{The Chi-squared statistic.}

\item{n}{Total sample size.}

\item{nrow, ncol}{The number of rows/columns in the contingency table (ignored
for Phi when \code{adjust=FALSE} and \code{CI=NULL}).}

\item{ci}{Confidence Interval (CI) level}

\item{adjust}{Should the effect size be bias-corrected? Defaults to \code{FALSE}.}

\item{...}{Arguments passed to or from other methods.}

\item{phi}{The Phi statistic.}
}
\value{
A data frame with the effect size(s) between 0-1, and confidence
interval(s). See \code{\link[=cramers_v]{cramers_v()}}.
}
\description{
Convert between Chi square \eqn{(\chi^2)}{}, Cramer's V, phi (\eqn{\phi}) and
Cohen's \emph{w} for contingency tables or goodness of fit.
}
\details{
These functions use the following formulae:
\cr
\deqn{\phi = \sqrt{\chi^2 / n}}{phi = sqrt(X^2 / n)}
\cr
\deqn{Cramer's V = \phi / \sqrt{min(nrow,ncol)-1}}{Cramer's V = Phi / sqrt(min(nrow,ncol)-1)}
\cr
For adjusted versions, see Bergsma, 2013.
}
\note{
Cohen's \emph{w} is equivalent to \emph{Phi}.
}
\section{Confidence Intervals}{

Unless stated otherwise, confidence intervals are estimated using the
Noncentrality parameter method; These methods searches for a the best
non-central parameters (\code{ncp}s) of the noncentral t-, F- or Chi-squared
distribution for the desired tail-probabilities, and then convert these
\code{ncp}s to the corresponding effect sizes. (See full \link{effectsize-CIs} for
more.)
}

\section{CI Contains Zero}{

Keep in mind that \code{ncp} confidence intervals are inverted significance tests,
and only inform us about which values are not significantly different than
our sample estimate. (They do \emph{not} inform us about which values are
plausible, likely or compatible with our data.) Thus, when CIs contain the
value 0, this should \emph{not} be taken to mean that a null effect size is
supported by the data; Instead this merely reflects a non-significant test
statistic - i.e. the \emph{p}-value is greater than alpha (Morey et al., 2016).
\cr\cr
For positive only effect sizes (Eta squared, Cramer's V, etc.; Effect sizes
associated with Chi-squared and F distributions), this applies also to cases
where the lower bound of the CI is equal to 0. Even more care should be taken
when the \emph{upper} bound is equal to 0 - this occurs when \emph{p}-value is greater
than 1-alpha/2 making, the upper bound cannot be estimated, and the upper
bound is arbitrarily set to 0 (Steiger, 2004). For example:\if{html}{\out{<div class="r">}}\preformatted{eta_squared(aov(mpg ~ factor(gear) + factor(cyl), mtcars[1:7, ]))
}\if{html}{\out{</div>}}\preformatted{## # Effect Size for ANOVA (Type I)
## 
## Parameter    | Eta2 (partial) |       90\% CI
## --------------------------------------------
## factor(gear) |           0.58 | [0.00, 0.84]
## factor(cyl)  |           0.46 | [0.00, 0.78]
}
}

\examples{
contingency_table <- as.table(rbind(c(762, 327, 468), c(484, 239, 477), c(484, 239, 477)))

chisq.test(contingency_table)
#
#         Pearson's Chi-squared test
#
# data:  ctab
# X-squared = 41.234, df = 4, p-value = 2.405e-08

chisq_to_phi(41.234,
  n = sum(contingency_table),
  nrow = nrow(contingency_table),
  ncol = ncol(contingency_table)
)
chisq_to_cramers_v(41.234,
  n = sum(contingency_table),
  nrow = nrow(contingency_table),
  ncol = ncol(contingency_table)
)
}
\references{
\itemize{
\item Cumming, G., & Finch, S. (2001). A primer on the understanding, use, and
calculation of confidence intervals that are based on central and noncentral
distributions. Educational and Psychological Measurement, 61(4), 532-574.
\item Bergsma, W. (2013). A bias-correction for Cramer's V and Tschuprow's T.
Journal of the Korean Statistical Society, 42(3), 323-328.
}
}
\seealso{
Other effect size from test statistic: 
\code{\link{F_to_eta2}()},
\code{\link{t_to_d}()}
}
\concept{effect size from test statistic}
