% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{create_variable_definitions}
\alias{create_variable_definitions}
\title{Create variable definitions from a data frame}
\usage{
create_variable_definitions(dframe)
}
\arguments{
\item{dframe}{a data frame, one line is one variable definition. Must have at least the following column names: 'name', 'longname', 'units', 'missval', 'precision', 'type', 'type_description', 'location_type'}
}
\value{
a list of length equal to the number of rows in the input data frame
}
\description{
Given a data frame as input, create a list of variable definitions usable by the function \code{\link{create_efts_variables}} to create netCDF variables.
}
\examples{
varsDef = data.frame(name=letters[1:3], stringsAsFactors=FALSE)
varsDef$longname=paste('long name for', varsDef$name)
varsDef$units='mm'
varsDef$missval=-999.0
varsDef$precision='double'
varsDef$type=2
varsDef$type_description='accumulated over the previous time step'
varsDef$location_type='Point'
str(create_variable_definitions(varsDef))

}
\seealso{
See
   \code{\link{create_efts}} for examples
}
