% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{EI}
\alias{EI}
\title{Epigraph Index (EI) for a functional dataset}
\usage{
EI(curves, ...)
}
\arguments{
\item{curves}{\code{matrix} where each row represents a curve, and each column
represents values along the curve or \code{array} with dimension
\eqn{n \times p \times q} with \eqn{n} curves, \eqn{p} values along the curve, and
\eqn{q} dimensions.}

\item{...}{Ignored.}
}
\value{
numeric \code{vector} containing the EI for each curve.
}
\description{
The Epigraph Index of a curve x is one minus the proportion of curves
in the sample that are above x.
}
\examples{
x <- matrix(c(1, 2, 3, 3, 2, 1, 5, 2, 3, 9, 8, 7), ncol = 3, nrow = 4)
EI(x)

y <- array(c(1, 2, 3, 3, 2, 1, 5, 2, 3, 9, 8, 7, -1, -5, -6, 2, 3, 0, -1, 0, 2, -1, -2, 0),
  dim = c(3, 4, 2)
)
EI(y)

}
