% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.BPF}
\alias{print.BPF}
\title{Print a summary of an output of the BPF function}
\usage{
\method{print}{BPF}(x, ..., margins = TRUE, digits = 2)
}
\arguments{
\item{x}{An object output of the \strong{BPF} function.}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{margins}{A \code{TRUE/FALSE} argument informing if the margins of the transition matrix should be displayed. Default, \code{TRUE}.}

\item{digits}{Integer indicating the number of decimal places to be shown. Default, 2.}
}
\value{
{No return value, called for side effects.}
}
\description{
Print method for objects obtained with the BPF function.
}
\examples{
votes1 <- structure(list(P1 = c(16L, 4L, 13L, 6L, 1L, 16L, 6L, 17L, 48L, 14L),
                         P2 = c(8L, 3L, 0L, 5L, 1L, 4L, 7L, 6L, 28L, 8L),
                         P3 = c(38L, 11L, 11L, 3L, 13L, 39L, 14L, 34L, 280L, 84L),
                         P4 = c(66L, 5L, 18L, 39L, 30L, 57L, 35L, 65L, 180L, 78L),
                         P5 = c(14L, 0L, 5L, 2L, 4L, 21L, 6L, 11L, 54L, 9L),
                         P6 = c(8L, 2L, 5L, 3L, 0L, 7L, 7L, 11L, 45L, 17L),
                         P7 = c(7L, 3L, 5L, 2L, 3L, 17L, 7L, 13L, 40L, 8L)),
                         row.names = c(NA, 10L), class = "data.frame")
votes2 <- structure(list(C1 = c(2L, 1L, 2L, 2L, 0L, 4L, 0L, 4L, 19L, 14L),
                         C2 = c(7L, 3L, 1L, 7L, 2L, 5L, 3L, 10L, 21L, 6L),
                         C3 = c(78L, 7L, 28L, 42L, 28L, 84L, 49L, 85L, 260L, 100L),
                         C4 = c(56L, 14L, 20L, 7L, 19L, 54L, 22L, 50L, 330L, 91L),
                         C5 = c(14L, 3L, 6L, 2L, 3L, 14L, 8L, 8L, 45L, 7L)),
                         row.names = c(NA, 10L), class = "data.frame")
example <- BPF(votes1, votes2, local = "none")
print(example, digits = 1, margins = TRUE)

}
\author{
Jose M. Pavia, \email{pavia@uv.es}
}
