% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fips_extract.R
\name{fips_extract}
\alias{fips_extract}
\title{Extract geographic unit codes from FIPS codes.}
\usage{
fips_extract(df, fips_col = NULL, geo = NULL)
}
\arguments{
\item{df}{The dataframe, with one column containing FIPS codes.}

\item{fips_col}{A string denoting the column containing the FIPS codes.}

\item{geo}{A string denoting the smallest geographic unit in the FIPS code.
If NULL, the smallest geographic unit is determined based off the length of
the FIPS codes.}
}
\value{
A dataframe with additional columns containing the individual codes
 for different geographic units.
}
\description{
This function will split up a column of FIPS codes into several columns, each
containing the individual code at different units. It is agnostic to the
level of the FIPS codes (i.e., FIPS codes are not required to be 15 digits
long). However, this function assumes that all FIPS codes begin at the state
level of precision.
}
